<?php

declare (strict_types=1);
namespace CelerSearch\Vendor\Meilisearch\Contracts\TaskDetails;

use CelerSearch\Vendor\Meilisearch\Contracts\TaskDetails;
/**
 * @implements TaskDetails<array{
 *     dumpUid: non-empty-string|null
 * }>
 * @internal
 */
final class DumpCreationDetails implements TaskDetails
{
    /**
     * @param non-empty-string|null $dumpUid
     */
    public function __construct(public readonly ?string $dumpUid)
    {
    }
    public static function fromArray(array $data) : self
    {
        return new self($data['dumpUid']);
    }
}
