<?php

declare (strict_types=1);
namespace CelerSearch\Vendor\Meilisearch;

use CelerSearch\Vendor\Meilisearch\Endpoints\Batches;
use CelerSearch\Vendor\Meilisearch\Endpoints\ChatWorkspaces;
use CelerSearch\Vendor\Meilisearch\Endpoints\Delegates\HandlesBatches;
use CelerSearch\Vendor\Meilisearch\Endpoints\Delegates\HandlesChatWorkspaces;
use CelerSearch\Vendor\Meilisearch\Endpoints\Delegates\HandlesDumps;
use CelerSearch\Vendor\Meilisearch\Endpoints\Delegates\HandlesIndex;
use CelerSearch\Vendor\Meilisearch\Endpoints\Delegates\HandlesKeys;
use CelerSearch\Vendor\Meilisearch\Endpoints\Delegates\HandlesMultiSearch;
use CelerSearch\Vendor\Meilisearch\Endpoints\Delegates\HandlesNetwork;
use CelerSearch\Vendor\Meilisearch\Endpoints\Delegates\HandlesSnapshots;
use CelerSearch\Vendor\Meilisearch\Endpoints\Delegates\HandlesSystem;
use CelerSearch\Vendor\Meilisearch\Endpoints\Delegates\HandlesTasks;
use CelerSearch\Vendor\Meilisearch\Endpoints\Dumps;
use CelerSearch\Vendor\Meilisearch\Endpoints\Health;
use CelerSearch\Vendor\Meilisearch\Endpoints\Indexes;
use CelerSearch\Vendor\Meilisearch\Endpoints\Keys;
use CelerSearch\Vendor\Meilisearch\Endpoints\Network;
use CelerSearch\Vendor\Meilisearch\Endpoints\Snapshots;
use CelerSearch\Vendor\Meilisearch\Endpoints\Stats;
use CelerSearch\Vendor\Meilisearch\Endpoints\Tasks;
use CelerSearch\Vendor\Meilisearch\Endpoints\TenantToken;
use CelerSearch\Vendor\Meilisearch\Endpoints\Version;
use CelerSearch\Vendor\Meilisearch\Http\Client as MeilisearchClientAdapter;
use CelerSearch\Vendor\Psr\Http\Client\ClientInterface;
use CelerSearch\Vendor\Psr\Http\Message\RequestFactoryInterface;
use CelerSearch\Vendor\Psr\Http\Message\StreamFactoryInterface;
/** @internal */
class Client
{
    use HandlesChatWorkspaces;
    use HandlesDumps;
    use HandlesIndex;
    use HandlesTasks;
    use HandlesKeys;
    use HandlesSnapshots;
    use HandlesSystem;
    use HandlesMultiSearch;
    use HandlesBatches;
    use HandlesNetwork;
    /**
     * @param array<int, string> $clientAgents
     */
    public function __construct(string $url, ?string $apiKey = null, ?ClientInterface $httpClient = null, ?RequestFactoryInterface $requestFactory = null, array $clientAgents = [], ?StreamFactoryInterface $streamFactory = null)
    {
        $this->http = new MeilisearchClientAdapter($url, $apiKey, $httpClient, $requestFactory, $clientAgents, $streamFactory);
        $this->chats = new ChatWorkspaces($this->http);
        $this->index = new Indexes($this->http);
        $this->health = new Health($this->http);
        $this->version = new Version($this->http);
        $this->stats = new Stats($this->http);
        $this->tasks = new Tasks($this->http);
        $this->batches = new Batches($this->http);
        $this->keys = new Keys($this->http);
        $this->dumps = new Dumps($this->http);
        $this->snapshots = new Snapshots($this->http);
        $this->tenantToken = new TenantToken($this->http, $apiKey);
        $this->network = new Network($this->http);
    }
}
