<?php

namespace CelerSearch\Vendor\IgniteKit\Validation\Rules;

use CelerSearch\Vendor\IgniteKit\Validation\Rule;
/** @internal */
class Present extends Rule
{
    /** @var bool */
    protected $implicit = \true;
    /** @var string */
    protected $message = "The :attribute must be present";
    /**
     * Check the $value is valid
     *
     * @param mixed $value
     *
     * @return bool
     */
    public function check($value) : bool
    {
        $this->setAttributeAsRequired();
        return $this->validation->hasValue($this->attribute->getKey());
    }
    /**
     * Set attribute is required if $this->attribute is set
     *
     * @return void
     */
    protected function setAttributeAsRequired()
    {
        if ($this->attribute) {
            $this->attribute->setRequired(\true);
        }
    }
}
