<?php

namespace CelerSearch\Vendor\IgniteKit\Validation\Rules;

use CelerSearch\Vendor\IgniteKit\Validation\Rule;
/** @internal */
class Max extends Rule
{
    use Traits\SizeTrait;
    /** @var string */
    protected $message = "The :attribute maximum is :max";
    /** @var array */
    protected $fillableParams = ['max'];
    /**
     * Check the $value is valid
     *
     * @param  mixed  $value
     *
     * @return bool
     * @throws \IgniteKit\Validation\MissingRequiredParameterException
     */
    public function check($value) : bool
    {
        $this->requireParameters($this->fillableParams);
        $max = $this->getBytesSize($this->parameter('max'));
        $valueSize = $this->getValueSize($value);
        if (!\is_numeric($valueSize)) {
            return \false;
        }
        return $valueSize <= $max;
    }
}
