<?php

namespace CelerSearch\Vendor\IgniteKit\Validation\Rules;

use CelerSearch\Vendor\IgniteKit\Validation\Rule;
/** @internal */
class Ipv6 extends Rule
{
    /** @var string */
    protected $message = "The :attribute is not valid IPv6 Address";
    /**
     * Check the $value is valid
     *
     * @param mixed $value
     * @return bool
     */
    public function check($value) : bool
    {
        return \filter_var($value, \FILTER_VALIDATE_IP, \FILTER_FLAG_IPV6) !== \false;
    }
}
