<?php
/**
 * Main search view template
 *
 * Override by copying to: your-theme/celersearch/views/search/search.php
 *
 * @var array              $template_args
 * @var CelerSearch\Views\SearchView $template_args['view']
 * @var array              $template_args['config']
 * @var string             $template_args['unique_id']
 * @var array              $template_args['templates']
 *
 * @package CelerSearch
 */

defined( 'ABSPATH' ) || exit;

$view      = $template_args['view'];
$config    = $template_args['config'];
$unique_id = $template_args['unique_id'];
$templates = $template_args['templates'];

$classes = [ 'cs-search' ];
if ( ! empty( $config['class'] ) ) {
	$classes[] = sanitize_html_class( $config['class'] );
}
if ( ! $config['show_facets'] ) {
	$classes[] = 'cs-search--no-facets';
}
?>
<div id="<?php echo esc_attr( $unique_id ); ?>"
     class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>"
     data-instance-id="<?php echo esc_attr( $unique_id ); ?>">

	<div class="cs-search__header">
		<div class="cs-search__input-wrap">
			<input type="search"
			       class="cs-search__input"
			       placeholder="<?php echo esc_attr( $config['placeholder'] ); ?>"
			       autocomplete="off"
			       aria-label="<?php esc_attr_e( 'Search', 'celersearch' ); ?>">
			<span class="cs-search__spinner" aria-hidden="true"></span>
		</div>
	</div>

	<div class="cs-search__active-filters" style="display:none;"></div>

	<div class="cs-search__body">
		<?php if ( $config['show_facets'] ) : ?>
		<aside class="cs-search__facets" aria-label="<?php esc_attr_e( 'Filters', 'celersearch' ); ?>">
			<div class="cs-search__facets-inner"></div>
		</aside>
		<?php endif; ?>

		<div class="cs-search__main">
			<div class="cs-search__status" aria-live="polite"></div>
			<div class="cs-search__results"></div>
			<div class="cs-search__pagination"></div>
		</div>
	</div>

	<?php foreach ( $templates as $name => $html ) : ?>
	<script type="text/template" data-template="<?php echo esc_attr( $name ); ?>"><?php echo $html; ?></script>
	<?php endforeach; ?>
</div>
