<?php
/**
 * Search result item template
 *
 * Override by copying to: your-theme/celersearch/views/search/result-item.php
 *
 * Available placeholders:
 * - {{id}}              - Post ID
 * - {{title}}           - Post title (highlighted if enabled)
 * - {{excerpt}}         - Excerpt (highlighted if enabled)
 * - {{url}}             - Permalink
 * - {{thumbnail}}       - Thumbnail URL (empty string if none)
 * - {{post_type}}       - Post type slug
 * - {{post_type_label}} - Post type label
 * - {{date}}            - Formatted date
 * - {{author}}          - Author display name
 *
 * Conditional blocks:
 * - {{#thumbnail}}...{{/thumbnail}}   - Renders only if thumbnail exists
 * - {{^thumbnail}}...{{/thumbnail}}   - Renders only if NO thumbnail
 *
 * @package CelerSearch
 */

defined( 'ABSPATH' ) || exit;
?>
<div class="cs-search__item" data-post-id="{{id}}">
	<a href="{{url}}" class="cs-search__item-link">
		{{#thumbnail}}
		<img class="cs-search__item-thumb" src="{{thumbnail}}" alt="" loading="lazy">
		{{/thumbnail}}
		<div class="cs-search__item-body">
			<span class="cs-search__item-type">{{post_type_label}}</span>
			<h3 class="cs-search__item-title">{{title}}</h3>
			<p class="cs-search__item-excerpt">{{excerpt}}</p>
			<div class="cs-search__item-meta">
				<span class="cs-search__item-date">{{date}}</span>
				<span class="cs-search__item-author">{{author}}</span>
			</div>
		</div>
	</a>
</div>
