<?php
/**
 * Pagination template (used as JS template)
 *
 * Override by copying to: your-theme/celersearch/views/search/pagination.php
 *
 * Placeholders:
 * - {{current_page}}  - Current page number
 * - {{total_pages}}   - Total pages
 * - {{prev_disabled}} - 'disabled' or ''
 * - {{next_disabled}} - 'disabled' or ''
 *
 * @package CelerSearch
 */

defined( 'ABSPATH' ) || exit;
?>
<nav class="cs-search__pagination-nav" aria-label="<?php esc_attr_e( 'Search results pagination', 'celersearch' ); ?>">
	<button class="cs-search__pagination-btn cs-search__pagination-btn--prev" data-page="prev" {{prev_disabled}}>
		&laquo; <?php esc_html_e( 'Previous', 'celersearch' ); ?>
	</button>
	<span class="cs-search__pagination-info">
		{{current_page}} / {{total_pages}}
	</span>
	<button class="cs-search__pagination-btn cs-search__pagination-btn--next" data-page="next" {{next_disabled}}>
		<?php esc_html_e( 'Next', 'celersearch' ); ?> &raquo;
	</button>
</nav>
