<?php
/**
 * Autocomplete suggestion item template
 *
 * This template renders each search result in the autocomplete dropdown.
 * Override by copying to: your-theme/celersearch/autocomplete/suggestion.php
 *
 * Available placeholders for JS:
 * - {{index}} - Item index (0-based)
 * - {{id}} - Post ID
 * - {{post_type}} - Post type slug
 * - {{post_type_label}} - Post type label (e.g., "Post", "Page")
 * - {{title}} - Post title (highlighted if match)
 * - {{excerpt}} - Post excerpt (highlighted if match)
 * - {{url}} - Post permalink
 * - {{edit_url}} - Admin edit URL
 * - {{thumbnail}} - Thumbnail URL (may be empty)
 *
 * @package CelerSearch
 */

defined( 'ABSPATH' ) || exit;
?>
<li class="celersearch-autocomplete__item"
    role="option"
    data-suggestion-index="{{index}}"
    data-post-id="{{id}}">
	<div class="celersearch-autocomplete__item-inner">
		<div class="celersearch-autocomplete__thumbnail-wrap">
			{{#thumbnail}}
			<img class="celersearch-autocomplete__thumbnail"
			     src="{{thumbnail}}"
			     alt=""
			     loading="lazy">
			{{/thumbnail}}
			{{^thumbnail}}
			<span class="celersearch-autocomplete__thumbnail-placeholder"></span>
			{{/thumbnail}}
		</div>
		<div class="celersearch-autocomplete__content">
			<span class="celersearch-autocomplete__post-type">{{post_type_label}}</span>
			<a href="{{url}}" class="celersearch-autocomplete__title">{{title}}</a>
			<p class="celersearch-autocomplete__excerpt">{{excerpt}}</p>
		</div>
		{{#show_actions}}
		<div class="celersearch-autocomplete__actions">
			<a href="{{url}}" class="celersearch-autocomplete__action celersearch-autocomplete__action--view" title="View">
				<span class="dashicons dashicons-visibility"></span>
			</a>
			{{#edit_url}}
			<a href="{{edit_url}}" class="celersearch-autocomplete__action celersearch-autocomplete__action--edit" title="Edit">
				<span class="dashicons dashicons-edit"></span>
			</a>
			{{/edit_url}}
		</div>
		{{/show_actions}}
	</div>
</li>
