<?php
/**
 * Autocomplete header template
 *
 * This template is shown at the top of the autocomplete dropdown.
 * Override by copying to: your-theme/celersearch/autocomplete/header.php
 *
 * Available placeholders for JS:
 * - {{query}} - Search query string
 * - {{total}} - Total number of results
 *
 * @package CelerSearch
 */

defined( 'ABSPATH' ) || exit;

// Header is optional - empty by default
// Uncomment below to show a header:
/*
?>
<div class="celersearch-autocomplete__header">
	<span class="celersearch-autocomplete__results-count">
		<?php
		printf(
			esc_html( _n( '%s result', '%s results', '{{total}}', 'celersearch' ) ),
			'{{total}}'
		);
		?>
	</span>
</div>
<?php
*/
