<?php

namespace CelerSearch\Views;

defined( 'ABSPATH' ) || exit;

/**
 * Static tracker of active view instances on current page
 *
 * Used by ViewAssets to determine which assets need to be enqueued.
 */
class ViewRegistry {

	/**
	 * Registered view instances
	 *
	 * @var AbstractView[]
	 */
	private static array $views = [];

	/**
	 * Register a view instance
	 *
	 * @param AbstractView $view
	 *
	 * @return void
	 */
	public static function register( AbstractView $view ): void {
		self::$views[] = $view;
	}

	/**
	 * Get all registered views
	 *
	 * @return AbstractView[]
	 */
	public static function get_views(): array {
		return self::$views;
	}

	/**
	 * Check if any views have been registered
	 *
	 * @return bool
	 */
	public static function has_views(): bool {
		return ! empty( self::$views );
	}

	/**
	 * Get all registered views of a specific type
	 *
	 * @param string $class Fully qualified class name.
	 *
	 * @return AbstractView[]
	 */
	public static function get_views_by_type( string $class ): array {
		return array_filter( self::$views, fn( $view ) => $view instanceof $class );
	}
}
