<?php

namespace CelerSearch\Utilities;

defined( 'ABSPATH' ) || exit;

class DateTimeUtilities {

	/**
	 * Format a date string into WordPress date and time format
	 *
	 * @param string $date The date string to format.
	 * @param string $soruce_format The source format of the date string. Default is 'Y-m-d H:i:s'.
	 * @return string The formatted date string.
	 */
	public static function format( string $date, string $soruce_format = 'Y-m-d H:i:s' ): string {

		$datetime = \DateTime::createFromFormat( $soruce_format, $date );
		if ( $datetime === false ) {
			return $date;
		}

		$date_format = get_option( 'date_format' );
		$time_format = get_option( 'time_format' );

		/* translators: 1: date, 2: time */
		return sprintf( __( '%1$s at %2$s', 'celersearch' ), $datetime->format( $date_format ), $datetime->format( $time_format ) );

	}

}