<?php

namespace CelerSearch\Utilities;

class ArrayUtilities {

	/**
	 * Removes the secondary value
	 * @param array $arr
	 *
	 * before:
	 *   [
	 *      'a:b',
	 *      'b:c',
	 *      'c:d',
	 *   ]
	 * after:
	 *   [
	 *      'a',
	 *      'b',
	 *      'c',
	 *   ]
	 *
	 * @return mixed
	 */
	public static function remove_secondary_value( array $arr ) : array {
		foreach ( $arr as $i => $v ) {
			if ( strpos( $v, ':' ) !== false ) {
				$parts     = explode( ':', $v );
				$arr[ $i ] = $parts[0];
			}
		}
		return $arr;
	}

}