<?php

namespace CelerSearch\Shortcodes;

defined( 'ABSPATH' ) || exit;

use CelerSearch\Interfaces\IRegistrable;

/**
 * Registers all shortcodes
 */
class Boot implements IRegistrable {

	/**
	 * @inheritDoc
	 */
	public function register(): void {
		add_action( 'init', [ $this, 'register_shortcodes' ] );
	}

	/**
	 * Register shortcode handlers
	 *
	 * @return void
	 */
	public function register_shortcodes(): void {
		$shortcodes = [
			new SearchShortcode(),
		];

		/**
		 * Filter registered shortcode classes
		 *
		 * @param AbstractShortcode[] $shortcodes Array of shortcode instances.
		 */
		$shortcodes = apply_filters( 'celersearch_shortcodes', $shortcodes );

		foreach ( $shortcodes as $shortcode ) {
			$shortcode->register();
		}
	}
}
