<?php

namespace CelerSearch\SearchAreas;

/**
 * WooCommerce Shop Browse search area
 *
 * Powers shop pages, product category/tag archives, and product attribute
 * archives with Meilisearch. Unlike WooCommerceProductSearchArea (which handles
 * search widget autocomplete), this area intercepts browse queries — no search
 * term required.
 */
class WooCommerceShopBrowseArea extends AbstractSearchArea {

	/**
	 * Get the unique type identifier
	 *
	 * @return string
	 */
	public function get_type(): string {
		return 'woocommerce_shop_browse';
	}

	/**
	 * Get the human-readable label
	 *
	 * @return string
	 */
	public function get_label(): string {
		return __( 'WooCommerce Shop Browse', 'celersearch' );
	}

	/**
	 * Get the CSS selector for search inputs
	 *
	 * This area does not attach to any inputs — it only intercepts queries.
	 *
	 * @return string
	 */
	public function get_input_selector(): string {
		return '';
	}

	/**
	 * Check if this search area should attach in the current context
	 *
	 * This area does not attach to DOM elements — it only participates
	 * in query interception via QueryIntegration.
	 *
	 * @return bool
	 */
	public function should_attach(): bool {
		return false;
	}

	/**
	 * This area does not support autocomplete
	 *
	 * @return bool
	 */
	public function supports_autocomplete(): bool {
		return false;
	}

	/**
	 * Get the context this area operates in
	 *
	 * @return string
	 */
	public function get_context(): string {
		return 'frontend';
	}
}
