<?php

namespace CelerSearch\SearchAreas;

/**
 * Public/Frontend WordPress search area
 *
 * Handles autocomplete for the standard WordPress search form
 * on the frontend of the site.
 */
class PublicSearchArea extends AbstractSearchArea {

	/**
	 * Get the unique type identifier
	 *
	 * @return string
	 */
	public function get_type(): string {
		return 'wordpress_public_search';
	}

	/**
	 * Get the human-readable label
	 *
	 * @return string
	 */
	public function get_label(): string {
		return __( 'WordPress Public Search', 'celersearch' );
	}

	/**
	 * Get the CSS selector for search inputs
	 *
	 * @return string
	 */
	public function get_input_selector(): string {
		$selector = 'input[name="s"]:not(.no-autocomplete):not(#adminbar-search)';

		return (string) apply_filters( 'celersearch_public_search_input_selector', $selector );
	}

	/**
	 * Check if this search area should attach in the current context
	 *
	 * @return bool
	 */
	public function should_attach(): bool {
		// Only attach on frontend, not in admin or AJAX
		if ( is_admin() || wp_doing_ajax() ) {
			return false;
		}

		// Allow filtering
		return (bool) apply_filters( 'celersearch_public_search_should_attach', true, $this );
	}

	/**
	 * Get the context this area operates in
	 *
	 * @return string
	 */
	public function get_context(): string {
		return 'frontend';
	}
}
