<?php

namespace CelerSearch\Queue;

defined( 'ABSPATH' ) || exit;

/**
 * Queue configuration settings
 */
class QueueSettings {

	/**
	 * Check if queue processing is enabled
	 *
	 * Queue is automatically enabled when Action Scheduler is available.
	 *
	 * @return bool
	 */
	public static function is_queue_enabled(): bool {
		$enabled = Queue::is_available();

		return apply_filters( 'celersearch_queue_enabled', $enabled );
	}
}
