<?php

namespace CelerSearch;

use CelerSearch\Indices\BaseIndex;
use CelerSearch\Observers\BaseObserver;

class Manager {

	/**
	 * The indices
	 * @var BaseIndex[]
	 */
	protected array $indices = [];

	/**
	 * The observers
	 * @var BaseObserver[]
	 */
	protected array $observers = [];

	/**
	 * Add index
	 *
	 * @param BaseIndex $index
	 *
	 * @return void
	 */
	public function add_index( BaseIndex $index ): void {
		$this->indices[] = $index;
	}

	/**
	 * Returns the indices
	 *
	 * @return BaseIndex[]
	 */
	public function get_indices(): array {
		return $this->indices;
	}

	/**
	 * Add observer
	 *
	 * @param BaseObserver $observer
	 *
	 * @return void
	 */
	public function add_observer( BaseObserver $observer ): void {
		$this->observers[] = $observer;
	}

	/**
	 * Returns the observers
	 *
	 * @return BaseObserver[]
	 */
	public function get_observers(): array {
		return $this->observers;
	}

	/**
	 * Start observing for changes
	 *
	 * @return void
	 */
	public function observe(): void {
		static $observing = false;

		if ( $observing ) {
			return;
		}

		foreach ( $this->observers as $observer ) {
			$observer->observe();
		}

		$observing = true;
	}
}