<?php

namespace CelerSearch\Interfaces;

use CelerSearch\Abstracts\RepositoryItem;

interface IRepository {

	/**
	 * Retrieve multiple records from the database
	 *
	 * @param  array  $query
	 * @param  int  $page
	 * @param  int  $per_page
	 * @param  string  $order
	 * @param  string  $orderBy
	 *
	 * @return array<RepositoryItem>
	 */
	public function get( array $query = [], int $page = 1, int $per_page = 10, string $order = 'DESC', string $orderBy = 'created_at') : array;

	/**
	 * Retrieve specific record from the database
	 *
	 * @param int $id
	 *
	 * @return RepositoryItem|null
	 */
	public function find( int $id ) : ?RepositoryItem;

	/**
	 * Store specific record in the database
	 * @param array $data
	 *
	 * @return RepositoryItem|null
	 */
	public function create( array $data ) : ?RepositoryItem;

	/**
	 * Update specific record in the database
	 *
	 * @param int $id
	 * @param array $data
	 *
	 * @return RepositoryItem|null
	 */
	public function update( int $id, array $data ) : ?RepositoryItem;

	/**
	 * Delete specific record in the database
	 * @param int $id
	 *
	 * @return bool
	 */
	public function delete( int $id ) : bool;


	/**
	 * Count records in the database
	 *
	 * @param array $query
	 *
	 * @return int
	 */
	public function count(array $query = []) : int;

}