<?php
namespace CelerSearch\Interfaces;

interface IIndexSettingsBuilder {
	/**
	 * Set up searchable attributes
	 * @param  array  $attributes
	 *
	 * @return $this
	 */
	public function searchable_attributes(array $attributes) : self;
	/**
	 * Set up filterable attributes
	 * @param  array  $attributes
	 *
	 * @return $this
	 */
	public function filterable_attributes(array $attributes) : self;
	/**
	 * Set up distinct attribute
	 * @param  string  $attribute
	 *
	 * @return $this
	 */
	public function distinct_attribute(string $attribute) : self;

	/**
	 * Set up sortable attributes
	 * @param  array  $attributes
	 *
	 * @return $this
	 */
	public function sortable_attributes(array $attributes) : self;

	/**
	 * Set up snippet attributes
	 * @param  array  $attributes
	 *
	 * @return $this
	 */
	public function snippet_attributes(array $attributes) : self;

	/**
	 * The max hits returned
	 * @param $hits
	 *
	 * @return mixed
	 */
	public function max_hits($hits) : self;
}