<?php

namespace CelerSearch\Factories;

use CelerSearch\Services\MeiliSearch;

class ProviderFactory {

	/**
	 * Return a supported provider
	 * @param $slug
	 *
	 * @return array|null
	 */
	public static function get_provider($slug) : array|null {

		$provider = null;
		foreach(self::get_supported_providers() as $_provider) {
			if ($_provider['slug'] === $slug) {
				$provider = $_provider;
				break;
			}
		}

		return $provider;

	}

	/**
	 * Returns the supported services
	 * @return array
	 */
	public static function get_supported_providers() : array {
		return apply_filters( 'celersearch_supported_providers', [
			[
				'name'   => 'MeiliSearch',
				'slug'   => 'meilisearch',
				'model'  => MeiliSearch::class,
				'fields' => [
					[
						'name'  => 'url',
						'label' => __( 'URL', 'celersearch' ),
						'type'  => 'text',
						'rules' => 'required|url'
					],
					[
						'name'  => 'api_key',
						'label' => __( 'API Key', 'celersearch' ),
						'type'  => 'text',
						'rules' => 'required'
					],
				],
			],
		] );
	}

}