<?php

namespace CelerSearch\Factories;

use CelerSearch\Indices\BaseIndex;
use CelerSearch\Indices\PostsIndex;
use CelerSearch\Manager;

class ManagerFactory {

	/**
	 * Returns all the possible indexes
	 * @return Manager
	 */
	public static function create() {

		$manager = new Manager();

		// Searchable posts
		$searchable_post_types = get_post_types(
			array(
				'exclude_from_search' => false,
			),
			'names'
		);
		$searchable_post_types = (array) apply_filters( 'celersearch_searchable_post_types', $searchable_post_types );
		//$manager->add_index( new PostsIndex( 'searchable', __( 'Searchable Posts' ), $searchable_post_types ) );


		// All other post types
		foreach ( $searchable_post_types as $post_type ) {
			//$manager->add_index( new PostsIndex( $post_type, ucfirst( str_replace( '_', '-', $post_type ) ), [ $post_type ] ) );
		}

		return $manager;

	}

}