<?php

namespace CelerSearch\DataTransfer;

/**
 * Stop words presets for various languages
 */
class StopWordsPresets {

	/**
	 * Get stop words for a specific language
	 *
	 * @param string $language Language code (e.g., 'en', 'de', 'fr', 'es')
	 *
	 * @return array
	 */
	public static function get( string $language ): array {
		return match ( $language ) {
			'en' => [
				'a', 'an', 'the', 'and', 'or', 'but', 'in', 'on', 'at', 'to', 'for',
				'of', 'with', 'by', 'from', 'is', 'are', 'was', 'were', 'be', 'been',
				'being', 'have', 'has', 'had', 'do', 'does', 'did', 'will', 'would',
				'could', 'should', 'may', 'might', 'must', 'shall', 'can', 'this',
				'that', 'these', 'those', 'it', 'its', 'as', 'if', 'not', 'no', 'so',
				'than', 'too', 'very', 'just', 'about', 'into', 'through', 'during',
				'before', 'after', 'above', 'below', 'between', 'under', 'again',
				'further', 'then', 'once', 'here', 'there', 'when', 'where', 'why',
				'how', 'all', 'each', 'few', 'more', 'most', 'other', 'some', 'such',
				'only', 'own', 'same', 'than', 'your', 'yours', 'yourself', 'he',
				'him', 'his', 'himself', 'she', 'her', 'hers', 'herself', 'we', 'us',
				'our', 'ours', 'ourselves', 'you', 'they', 'them', 'their', 'theirs',
				'themselves', 'what', 'which', 'who', 'whom', 'whose', 'i', 'me', 'my',
				'myself', 'am',
			],
			'de' => [
				'der', 'die', 'das', 'ein', 'eine', 'einer', 'einem', 'einen', 'eines',
				'und', 'oder', 'aber', 'in', 'an', 'auf', 'zu', 'für', 'von', 'mit',
				'bei', 'aus', 'ist', 'sind', 'war', 'waren', 'sein', 'haben', 'hat',
				'hatte', 'hatten', 'wird', 'werden', 'wurde', 'wurden', 'kann', 'können',
				'konnte', 'konnten', 'muss', 'müssen', 'musste', 'mussten', 'soll',
				'sollen', 'sollte', 'sollten', 'will', 'wollen', 'wollte', 'wollten',
				'darf', 'dürfen', 'durfte', 'durften', 'mag', 'mögen', 'mochte', 'mochten',
				'nicht', 'kein', 'keine', 'keiner', 'keinem', 'keinen', 'keines', 'als',
				'wenn', 'weil', 'obwohl', 'ob', 'dass', 'daß', 'so', 'wie', 'wo', 'wer',
				'was', 'wann', 'warum', 'welche', 'welcher', 'welches', 'welchem', 'welchen',
				'dieser', 'diese', 'dieses', 'diesem', 'diesen', 'jener', 'jene', 'jenes',
				'jenem', 'jenen', 'hier', 'dort', 'da', 'nun', 'noch', 'schon', 'auch',
				'nur', 'sehr', 'mehr', 'immer', 'wieder', 'selbst', 'sich', 'ihm', 'ihr',
				'ihnen', 'sein', 'seine', 'seiner', 'seinem', 'seinen', 'ihre', 'ihrer',
				'ihrem', 'ihren', 'ich', 'du', 'er', 'sie', 'es', 'wir', 'ihr', 'Sie',
				'mein', 'meine', 'meiner', 'meinem', 'meinen', 'dein', 'deine', 'deiner',
				'deinem', 'deinen', 'unser', 'unsere', 'unserer', 'unserem', 'unseren',
				'euer', 'eure', 'eurer', 'eurem', 'euren',
			],
			'fr' => [
				'le', 'la', 'les', 'un', 'une', 'des', 'du', 'de', 'et', 'ou', 'mais',
				'dans', 'sur', 'à', 'au', 'aux', 'pour', 'avec', 'par', 'est', 'sont',
				'était', 'étaient', 'être', 'avoir', 'a', 'ont', 'avait', 'avaient',
				'sera', 'seront', 'serait', 'seraient', 'fait', 'faire', 'ne', 'pas',
				'plus', 'moins', 'très', 'trop', 'bien', 'mal', 'si', 'comme', 'quand',
				'où', 'qui', 'que', 'quoi', 'dont', 'comment', 'pourquoi', 'ce', 'cette',
				'ces', 'cet', 'celui', 'celle', 'ceux', 'celles', 'ici', 'là', 'voici',
				'voilà', 'il', 'elle', 'ils', 'elles', 'on', 'nous', 'vous', 'je', 'tu',
				'me', 'te', 'se', 'lui', 'leur', 'leurs', 'mon', 'ma', 'mes', 'ton',
				'ta', 'tes', 'son', 'sa', 'ses', 'notre', 'nos', 'votre', 'vos', 'tout',
				'tous', 'toute', 'toutes', 'autre', 'autres', 'même', 'mêmes', 'tel',
				'tels', 'telle', 'telles', 'quel', 'quels', 'quelle', 'quelles', 'chaque',
				'quelque', 'quelques', 'aucun', 'aucune', 'certain', 'certaine', 'certains',
				'certaines', 'plusieurs', 'entre', 'vers', 'chez', 'sans', 'sous', 'avant',
				'après', 'pendant', 'depuis', 'jusque', 'encore', 'déjà', 'toujours',
				'jamais', 'souvent', 'parfois', 'aussi', 'alors', 'donc', 'car', 'parce',
			],
			'es' => [
				'el', 'la', 'los', 'las', 'un', 'una', 'unos', 'unas', 'y', 'o', 'pero',
				'en', 'a', 'para', 'de', 'con', 'por', 'es', 'son', 'era', 'eran', 'ser',
				'estar', 'ha', 'han', 'había', 'habían', 'haber', 'tener', 'tiene',
				'tienen', 'tenía', 'tenían', 'hacer', 'hace', 'hacen', 'hacía', 'hacían',
				'no', 'sí', 'muy', 'más', 'menos', 'tan', 'como', 'si', 'cuando', 'donde',
				'quien', 'que', 'qué', 'cual', 'cuál', 'cuales', 'cuáles', 'cómo', 'por qué',
				'este', 'esta', 'estos', 'estas', 'ese', 'esa', 'esos', 'esas', 'aquel',
				'aquella', 'aquellos', 'aquellas', 'aquí', 'allí', 'ahí', 'él', 'ella',
				'ellos', 'ellas', 'nosotros', 'nosotras', 'vosotros', 'vosotras', 'ustedes',
				'yo', 'tú', 'usted', 'me', 'te', 'se', 'le', 'les', 'lo', 'los', 'la', 'las',
				'mi', 'mis', 'tu', 'tus', 'su', 'sus', 'nuestro', 'nuestra', 'nuestros',
				'nuestras', 'vuestro', 'vuestra', 'vuestros', 'vuestras', 'todo', 'toda',
				'todos', 'todas', 'otro', 'otra', 'otros', 'otras', 'mismo', 'misma',
				'mismos', 'mismas', 'cada', 'alguno', 'alguna', 'algunos', 'algunas',
				'ninguno', 'ninguna', 'varios', 'varias', 'mucho', 'mucha', 'muchos',
				'muchas', 'poco', 'poca', 'pocos', 'pocas', 'entre', 'sobre', 'bajo',
				'sin', 'desde', 'hasta', 'durante', 'ante', 'tras', 'según', 'contra',
				'hacia', 'ya', 'aún', 'todavía', 'siempre', 'nunca', 'también', 'además',
				'entonces', 'así', 'pues', 'porque', 'aunque', 'mientras', 'sino',
			],
			'it' => [
				'il', 'lo', 'la', 'i', 'gli', 'le', 'un', 'uno', 'una', 'e', 'o', 'ma',
				'in', 'a', 'per', 'di', 'da', 'con', 'su', 'è', 'sono', 'era', 'erano',
				'essere', 'avere', 'ha', 'hanno', 'aveva', 'avevano', 'fare', 'fa', 'fanno',
				'faceva', 'facevano', 'non', 'sì', 'molto', 'più', 'meno', 'tanto', 'come',
				'se', 'quando', 'dove', 'chi', 'che', 'cosa', 'quale', 'quali', 'perché',
				'questo', 'questa', 'questi', 'queste', 'quello', 'quella', 'quelli',
				'quelle', 'qui', 'lì', 'là', 'lui', 'lei', 'loro', 'noi', 'voi', 'io',
				'tu', 'mi', 'ti', 'si', 'ci', 'vi', 'lo', 'la', 'li', 'le', 'ne', 'mio',
				'mia', 'miei', 'mie', 'tuo', 'tua', 'tuoi', 'tue', 'suo', 'sua', 'suoi',
				'sue', 'nostro', 'nostra', 'nostri', 'nostre', 'vostro', 'vostra', 'vostri',
				'vostre', 'tutto', 'tutta', 'tutti', 'tutte', 'altro', 'altra', 'altri',
				'altre', 'stesso', 'stessa', 'stessi', 'stesse', 'ogni', 'qualche',
				'qualcuno', 'qualcuna', 'nessuno', 'nessuna', 'alcuni', 'alcune', 'tra',
				'fra', 'sopra', 'sotto', 'senza', 'verso', 'fino', 'durante', 'dopo',
				'prima', 'già', 'ancora', 'sempre', 'mai', 'anche', 'inoltre', 'quindi',
				'così', 'dunque', 'perché', 'sebbene', 'mentre', 'però',
			],
			'pt' => [
				'o', 'a', 'os', 'as', 'um', 'uma', 'uns', 'umas', 'e', 'ou', 'mas', 'em',
				'no', 'na', 'nos', 'nas', 'de', 'do', 'da', 'dos', 'das', 'para', 'por',
				'pelo', 'pela', 'pelos', 'pelas', 'com', 'sem', 'é', 'são', 'era', 'eram',
				'ser', 'estar', 'está', 'estão', 'estava', 'estavam', 'ter', 'tem', 'têm',
				'tinha', 'tinham', 'haver', 'há', 'havia', 'fazer', 'faz', 'fazem', 'fazia',
				'faziam', 'não', 'sim', 'muito', 'mais', 'menos', 'tão', 'como', 'se',
				'quando', 'onde', 'quem', 'que', 'qual', 'quais', 'porque', 'porquê',
				'este', 'esta', 'estes', 'estas', 'esse', 'essa', 'esses', 'essas',
				'aquele', 'aquela', 'aqueles', 'aquelas', 'aqui', 'ali', 'lá', 'ele',
				'ela', 'eles', 'elas', 'nós', 'vós', 'vocês', 'eu', 'tu', 'você', 'me',
				'te', 'se', 'lhe', 'lhes', 'meu', 'minha', 'meus', 'minhas', 'teu', 'tua',
				'teus', 'tuas', 'seu', 'sua', 'seus', 'suas', 'nosso', 'nossa', 'nossos',
				'nossas', 'vosso', 'vossa', 'vossos', 'vossas', 'todo', 'toda', 'todos',
				'todas', 'outro', 'outra', 'outros', 'outras', 'mesmo', 'mesma', 'mesmos',
				'mesmas', 'cada', 'algum', 'alguma', 'alguns', 'algumas', 'nenhum',
				'nenhuma', 'vários', 'várias', 'entre', 'sobre', 'sob', 'até', 'desde',
				'durante', 'após', 'antes', 'já', 'ainda', 'sempre', 'nunca', 'também',
				'além', 'então', 'assim', 'pois', 'embora', 'enquanto', 'porém',
			],
			'nl' => [
				'de', 'het', 'een', 'en', 'of', 'maar', 'in', 'op', 'aan', 'naar', 'voor',
				'van', 'met', 'bij', 'uit', 'is', 'zijn', 'was', 'waren', 'worden', 'wordt',
				'werd', 'werden', 'hebben', 'heeft', 'had', 'hadden', 'kunnen', 'kan',
				'kon', 'konden', 'moeten', 'moet', 'moest', 'moesten', 'willen', 'wil',
				'wilde', 'wilden', 'zullen', 'zal', 'zou', 'zouden', 'mogen', 'mag',
				'mocht', 'mochten', 'niet', 'geen', 'als', 'wanneer', 'omdat', 'of', 'dat',
				'die', 'deze', 'dit', 'wat', 'wie', 'waar', 'wanneer', 'waarom', 'hoe',
				'welke', 'welk', 'hier', 'daar', 'nu', 'nog', 'al', 'ook', 'alleen', 'zeer',
				'meer', 'altijd', 'weer', 'zelf', 'zich', 'hem', 'haar', 'hen', 'hun',
				'zijn', 'haar', 'ik', 'jij', 'je', 'u', 'hij', 'zij', 'ze', 'wij', 'we',
				'jullie', 'mijn', 'jouw', 'uw', 'onze', 'ons', 'jullie', 'hun',
			],
			default => [],
		};
	}

	/**
	 * Get available language presets
	 *
	 * @return array
	 */
	public static function available(): array {
		return [
			'en' => __( 'English', 'celersearch' ),
			'de' => __( 'German', 'celersearch' ),
			'fr' => __( 'French', 'celersearch' ),
			'es' => __( 'Spanish', 'celersearch' ),
			'it' => __( 'Italian', 'celersearch' ),
			'pt' => __( 'Portuguese', 'celersearch' ),
			'nl' => __( 'Dutch', 'celersearch' ),
		];
	}
}
