<?php

namespace CelerSearch\DataTransfer;

use CelerSearch\Interfaces\IBuilderObject;

class IndexSettings implements IBuilderObject {

	/**
	 * The primary key attribute
	 * @var string|null
	 */
	protected string|null $primary_key = null;

	/**
	 * The searchable attributes
	 * @var array
	 */
	protected array $searchable_attributes = [];

	/**
	 * The filterable attributes
	 * @var array
	 */
	protected array $filterable_attributes = [];

	/**
	 * The sortable attributes
	 * @var array
	 */
	protected array $sortable_attributes = [];

	/**
	 * The distinct attribute
	 * @var string|null
	 */
	protected string|null $distinct_attribute = null;

	/**
	 * The snippet attributes
	 * @var array
	 */
	protected array $snippet_attributes = [];

	/**
	 * The synonyms
	 * @var IndexSynonym[]
	 */
	protected array $synonyms = [];

	/**
	 * The maximum hits
	 * @var int
	 */
	protected int $max_hits = 1000;

	/**
	 * Typo tolerance enabled
	 * @var bool
	 */
	protected bool $typo_enabled = true;

	/**
	 * Minimum word size for one typo
	 * @var int
	 */
	protected int $typo_min_one = 5;

	/**
	 * Minimum word size for two typos
	 * @var int
	 */
	protected int $typo_min_two = 9;

	/**
	 * Words to disable typos on
	 * @var array
	 */
	protected array $typo_disable_words = [];

	/**
	 * Fields to disable typos on
	 * @var array
	 */
	protected array $typo_disable_fields = [];

	/**
	 * Stop words
	 * @var array
	 */
	protected array $stop_words = [];

	/**
	 * Maximum facet values
	 * @var int
	 */
	protected int $facet_max_values = 100;

	/**
	 * Ranking rules
	 * @var array
	 */
	protected array $ranking_rules = [];

	/**
	 * Proximity precision
	 * @var string
	 */
	protected string $proximity_precision = 'byWord';

	/**
	 * Token separators
	 * @var array
	 */
	protected array $token_separators = [];

	/**
	 * Non-token separators (symbols to keep as part of tokens)
	 * @var array
	 */
	protected array $non_token_separators = [];

	/**
	 * Get the primary key
	 *
	 * @return string|null
	 */
	public function get_primary_key(): string|null {
		return $this->primary_key;
	}

	/**
	 * Set the primary key
	 *
	 * @param string $primary_key
	 *
	 * @return void
	 */
	public function set_primary_key( string $primary_key ): void {
		$this->primary_key = $primary_key;
	}

	/**
	 * Get the searchable attributes
	 *
	 * @return array
	 */
	public function get_searchable_attributes(): array {
		return $this->searchable_attributes;
	}

	/**
	 * Set the searchable attributes
	 *
	 * @param array $searchable_attributes
	 *
	 * @return void
	 */
	public function set_searchable_attributes( array $searchable_attributes ): void {
		$this->searchable_attributes = $searchable_attributes;
	}

	/**
	 * Get the filterable attributes
	 *
	 * @return array
	 */
	public function get_filterable_attributes(): array {
		return $this->filterable_attributes;
	}

	/**
	 * Set the filterable attributes
	 *
	 * @param array $filterable_attributes
	 *
	 * @return void
	 */
	public function set_filterable_attributes( array $filterable_attributes ): void {
		$this->filterable_attributes = $filterable_attributes;
	}

	/**
	 * Get the sortable attributes
	 *
	 * @return array
	 */
	public function get_sortable_attributes(): array {
		return $this->sortable_attributes;
	}

	/**
	 * Set the sortable attributes
	 *
	 * @param array $sortable_attributes
	 *
	 * @return void
	 */
	public function set_sortable_attributes( array $sortable_attributes ): void {
		$this->sortable_attributes = $sortable_attributes;
	}

	/**
	 * Get the distinct attribute
	 *
	 * @return string|null
	 */
	public function get_distinct_attribute(): string|null {
		return $this->distinct_attribute;
	}

	/**
	 * Set the distinct attribute
	 *
	 * @param string $distinct_attribute
	 *
	 * @return void
	 */
	public function set_distinct_attribute( string $distinct_attribute ): void {
		$this->distinct_attribute = $distinct_attribute;
	}

	/**
	 * Get the snippet attributes
	 *
	 * @return array
	 */
	public function get_snippet_attributes(): array {
		return $this->snippet_attributes;
	}

	/**
	 * Set the snippet attributes
	 *
	 * @param array $snippet_attributes
	 *
	 * @return void
	 */
	public function set_snippet_attributes( array $snippet_attributes ): void {
		$this->snippet_attributes = $snippet_attributes;
	}

	/**
	 * Get the maximum hits
	 *
	 * @return int
	 */
	public function get_max_hits(): int {
		return $this->max_hits;
	}

	/**
	 * Set the maximum hits
	 *
	 * @param int $max_hits
	 *
	 * @return void
	 */
	public function set_max_hits( int $max_hits ): void {
		$this->max_hits = $max_hits;
	}

	/**
	 * Get the synonyms
	 *
	 * @return IndexSynonym[]
	 */
	public function get_synonyms(): array {
		return $this->synonyms;
	}

	/**
	 * Set the synonyms
	 *
	 * @param IndexSynonym[] $synonyms
	 *
	 * @return void
	 */
	public function set_synonyms( array $synonyms ): void {
		$this->synonyms = $synonyms;
	}

	/**
	 * Check if typo tolerance is enabled
	 *
	 * @return bool
	 */
	public function is_typo_enabled(): bool {
		return $this->typo_enabled;
	}

	/**
	 * Set typo tolerance enabled
	 *
	 * @param bool $typo_enabled
	 *
	 * @return void
	 */
	public function set_typo_enabled( bool $typo_enabled ): void {
		$this->typo_enabled = $typo_enabled;
	}

	/**
	 * Get minimum word size for one typo
	 *
	 * @return int
	 */
	public function get_typo_min_one(): int {
		return $this->typo_min_one;
	}

	/**
	 * Set minimum word size for one typo
	 *
	 * @param int $typo_min_one
	 *
	 * @return void
	 */
	public function set_typo_min_one( int $typo_min_one ): void {
		$this->typo_min_one = $typo_min_one;
	}

	/**
	 * Get minimum word size for two typos
	 *
	 * @return int
	 */
	public function get_typo_min_two(): int {
		return $this->typo_min_two;
	}

	/**
	 * Set minimum word size for two typos
	 *
	 * @param int $typo_min_two
	 *
	 * @return void
	 */
	public function set_typo_min_two( int $typo_min_two ): void {
		$this->typo_min_two = $typo_min_two;
	}

	/**
	 * Get words to disable typos on
	 *
	 * @return array
	 */
	public function get_typo_disable_words(): array {
		return $this->typo_disable_words;
	}

	/**
	 * Set words to disable typos on
	 *
	 * @param array $typo_disable_words
	 *
	 * @return void
	 */
	public function set_typo_disable_words( array $typo_disable_words ): void {
		$this->typo_disable_words = $typo_disable_words;
	}

	/**
	 * Get fields to disable typos on
	 *
	 * @return array
	 */
	public function get_typo_disable_fields(): array {
		return $this->typo_disable_fields;
	}

	/**
	 * Set fields to disable typos on
	 *
	 * @param array $typo_disable_fields
	 *
	 * @return void
	 */
	public function set_typo_disable_fields( array $typo_disable_fields ): void {
		$this->typo_disable_fields = $typo_disable_fields;
	}

	/**
	 * Get stop words
	 *
	 * @return array
	 */
	public function get_stop_words(): array {
		return $this->stop_words;
	}

	/**
	 * Set stop words
	 *
	 * @param array $stop_words
	 *
	 * @return void
	 */
	public function set_stop_words( array $stop_words ): void {
		$this->stop_words = $stop_words;
	}

	/**
	 * Get maximum facet values
	 *
	 * @return int
	 */
	public function get_facet_max_values(): int {
		return $this->facet_max_values;
	}

	/**
	 * Set maximum facet values
	 *
	 * @param int $facet_max_values
	 *
	 * @return void
	 */
	public function set_facet_max_values( int $facet_max_values ): void {
		$this->facet_max_values = $facet_max_values;
	}

	/**
	 * Get ranking rules
	 *
	 * @return array
	 */
	public function get_ranking_rules(): array {
		return $this->ranking_rules;
	}

	/**
	 * Set ranking rules
	 *
	 * @param array $ranking_rules
	 *
	 * @return void
	 */
	public function set_ranking_rules( array $ranking_rules ): void {
		$this->ranking_rules = $ranking_rules;
	}

	/**
	 * Get proximity precision
	 *
	 * @return string
	 */
	public function get_proximity_precision(): string {
		return $this->proximity_precision;
	}

	/**
	 * Set proximity precision
	 *
	 * @param string $proximity_precision
	 *
	 * @return void
	 */
	public function set_proximity_precision( string $proximity_precision ): void {
		$this->proximity_precision = $proximity_precision;
	}

	/**
	 * Get token separators
	 *
	 * @return array
	 */
	public function get_token_separators(): array {
		return $this->token_separators;
	}

	/**
	 * Set token separators
	 *
	 * @param array $token_separators
	 *
	 * @return void
	 */
	public function set_token_separators( array $token_separators ): void {
		$this->token_separators = $token_separators;
	}

	/**
	 * Get non-token separators
	 *
	 * @return array
	 */
	public function get_non_token_separators(): array {
		return $this->non_token_separators;
	}

	/**
	 * Set non-token separators
	 *
	 * @param array $non_token_separators
	 *
	 * @return void
	 */
	public function set_non_token_separators( array $non_token_separators ): void {
		$this->non_token_separators = $non_token_separators;
	}

}