<?php

namespace CelerSearch\DataTransfer\IndexResponses;

use CelerSearch\Abstracts\IndexResponse;

class SearchResponse extends IndexResponse {

	// Search related
	protected array $hits;
	protected int $total_hits;
	protected int $total_pages;
	protected int $hits_per_page;
	protected int $current_page;
	protected array $facet_distribution = [];
	protected array $facet_stats = [];

	public function get_hits(): array {
		return $this->hits;
	}

	public function set_hits( array $hits ): void {
		$this->hits = $hits;
	}

	public function get_total_hits(): int {
		return $this->total_hits;
	}

	public function set_total_hits( int $total_hits ): void {
		$this->total_hits = $total_hits;
	}

	public function set_total_pages( int $total_pages ): void {
		$this->total_pages = $total_pages;
	}

	public function get_total_pages(): int {
		return $this->total_pages;
	}

	public function set_hits_per_page( int $hits_per_page ): void {
		$this->hits_per_page = $hits_per_page;
	}

	public function get_hits_per_page(): int {
		return $this->hits_per_page;
	}

	public function set_current_page( int $current_page ): void {
		$this->current_page = $current_page;
	}

	public function get_current_page(): int {
		return $this->current_page;
	}

	public function set_facet_distribution( array $facet_distribution ): void {
		$this->facet_distribution = $facet_distribution;
	}

	public function get_facet_distribution(): array {
		return $this->facet_distribution;
	}

	public function set_facet_stats( array $facet_stats ): void {
		$this->facet_stats = $facet_stats;
	}

	public function get_facet_stats(): array {
		return $this->facet_stats;
	}

	/**
	 * Is error response?
	 * @return bool
	 */
	public function is_error_response(): bool {
		return false;
	}
}