<?php

namespace CelerSearch\DataTransfer\IndexResponses;

use CelerSearch\Abstracts\IndexResponse;

class ErrorResponse extends IndexResponse {

	protected mixed $error_code;
	protected string $error_message;

	/**
	 * Set the error code
	 *
	 * @param mixed $error_code
	 *
	 * @return void
	 */
	public function set_error_code( mixed $error_code ) : void {
		$this->error_code = $error_code;
	}

	/**
	 * Set the error message
	 *
	 * @param string $error_message
	 *
	 * @return void
	 */
	public function set_error_message( string $error_message ) : void {
		$this->error_message = $error_message;
	}

	/**
	 * Get the response code
	 * @return int
	 */
	public function get_response_code() : int {
		return $this->response_code;
	}

	/**
	 * Get the response body
	 * @return array
	 */
	public function get_response_body() : array {
		return $this->response_body;
	}

	/**
	 * Get the error code
	 * @return mixed
	 */
	public function get_error_code() : mixed {
		return $this->error_code;
	}

	/**
	 * Get the error message
	 * @return string
	 */
	public function get_error_message() : string {
		return $this->error_message;
	}

	/**
	 * Is error response?
	 * @return bool
	 */
	public function is_error_response(): bool {
		return true;
	}
}