<?php

defined( 'ABSPATH' ) || exit;

// Frontend translation files.

return [
	'global'   => [
		'actions'  => [
			'name'   => __( 'Actions', 'celersearch' ),
			'edit'   => __( 'Edit', 'celersearch' ),
			'delete' => __( 'Delete', 'celersearch' ),
		],
		'phrases'  => [
			'argh'           => __( 'Error!', 'celersearch' ),
			'error'          => __( 'An error occurred. Please try again.', 'celersearch' ),
			'confirm_delete' => __( 'Are you sure you want to delete this item?', 'celersearch' ),
			'select_one'     => __( 'Select one', 'celersearch' ),
			'fix_errors'     => __( 'Please fix the following errors:', 'celersearch' ),
			'success'        => __( 'Success!', 'celersearch' ),
			'no_records'     => __( 'No records found', 'celersearch' ),
			'loading'        => __( 'Loading...', 'celersearch' ),
		],
		'buttons'  => [
			'test'    => __( 'Test', 'celersearch' ),
			'save'    => __( 'Save', 'celersearch' ),
			'saving'  => __( 'Saving...', 'celersearch' ),
			'add_new' => __( 'Add New', 'celersearch' ),
			'add'     => __( 'Add', 'celersearch' ),
			'next'    => __( 'Next', 'celersearch' ),
			'back'    => __( 'Back', 'celersearch' ),
			'create'  => __( 'Create', 'celersearch' ),
			'update'  => __( 'Update', 'celersearch' ),
			'cancel'  => __( 'Cancel', 'celersearch' ),
			'close'   => __( 'Close', 'celersearch' ),
		],
		'statuses' => [
			'connected' => __( 'Connected', 'celersearch' ),
			'failed'    => __( 'Failed', 'celersearch' ),
			'failing'   => __( 'Failing', 'celersearch' ),
			'pending'   => __( 'Pending', 'celersearch' ),
			'active'    => __( 'Active', 'celersearch' ),
			'checking'  => __( 'Checking...', 'celersearch' ),
		],
		'pages'    => [
			'users' => __( 'Users', 'celersearch' ),
		]
	],
	'index'    => [
		'create'   => __( 'Create Index', 'celersearch' ),
		'edit'     => __( 'Update Index', 'celersearch' ),
		'subtitle' => __( 'Set up index for fast searching', 'celersearch' ),
	],
	'indices'  => [
		'title'   => __( 'Indices', 'celersearch' ),
		'labels'  => [
			'id'                  => __( 'ID', 'celersearch' ),
			'name'                => __( 'Name', 'celersearch' ),
			'index_type'          => __( 'Index Type', 'celersearch' ),
			'auto_generated_name' => __( 'Auto-generated name', 'celersearch' ),
			'use_custom_name'     => __( 'Use custom name', 'celersearch' ),
			'custom_name'         => __( 'Custom Name', 'celersearch' ),
			'slug'                => __( 'Slug', 'celersearch' ),
			'documents'           => __( 'Documents', 'celersearch' ),
			'service'             => __( 'Service', 'celersearch' ),
		],
		'actions' => [
			'index'    => __( 'Index', 'celersearch' ),
			'settings' => __( 'Settings', 'celersearch' ),
		],
		'steps'  => [
			'select_type'      => __( 'Index Type', 'celersearch' ),
			'configure_fields' => __( 'Configure', 'celersearch' ),
			'select_service'   => __( 'Service', 'celersearch' ),
		],
		'hints'  => [
			'multi_select'  => __( 'Click to select multiple options. Click X to remove.', 'celersearch' ),
			'service_info'  => __( 'Select which search service this index will use to store and search data.', 'celersearch' ),
		],
		'errors'   => [
			'select_type'          => __( 'Please select an index type', 'celersearch' ),
			'fill_required_fields' => __( 'Please fill in all required fields', 'celersearch' ),
		],
		'buttons'  => [
			'select_searchable' => __( 'Select all searchable types', 'celersearch' ),
		],
		'stats'   => [
			'checking'       => __( 'Checking...', 'celersearch' ),
			'refresh_stats'  => __( 'Refresh Stats', 'celersearch' ),
			'documents_hint' => __( 'Indexed / Total — documents in search engine vs local candidates', 'celersearch' ),
		],
		'indexing' => [
			'title'       => __( 'Indexing in Progress', 'celersearch' ),
			'progress'    => __( 'Progress', 'celersearch' ),
			'items'       => __( 'items', 'celersearch' ),
			'starting'    => __( 'Starting indexing...', 'celersearch' ),
			'processing'  => __( 'Processing items...', 'celersearch' ),
			'complete'    => __( 'Indexing completed successfully!', 'celersearch' ),
			'error'       => __( 'An error occurred during indexing.', 'celersearch' ),
			'cancelled'   => __( 'Indexing was cancelled.', 'celersearch' ),
			'cancelling'      => __( 'Cancelling...', 'celersearch' ),
			'confirm_title'   => __( 'Rebuild Index', 'celersearch' ),
			'confirm_message' => __( 'This will destroy the current index and rebuild it from scratch. All indexed data will be temporarily unavailable during the rebuild.', 'celersearch' ),
			'confirm_button'  => __( 'Start Rebuild', 'celersearch' ),
		]
	],
	'services' => [
		'title'        => __( 'Services', 'celersearch' ),
		'create'       => __( 'Create Service', 'celersearch' ),
		'edit'         => __( 'Update Service', 'celersearch' ),
		'subtitle'     => __( 'Connect your search service', 'celersearch' ),
		'valid'        => __( 'Yay! We have a connection!', 'celersearch' ),
		'check_status' => __( 'Re-check Status', 'celersearch' ),
		'labels'       => [
			'id'         => __( 'ID', 'celersearch' ),
			'name'       => __( 'Name', 'celersearch' ),
			'provider'   => __( 'Provider', 'celersearch' ),
			'status'     => __( 'Status', 'celersearch' ),
			'checked_at' => __( 'Checked At', 'celersearch' ),
			'created_at' => __( 'Created At', 'celersearch' ),
		],
		'steps'    => [
			'select_provider' => __( 'Provider', 'celersearch' ),
			'configure'       => __( 'Configure', 'celersearch' ),
			'test_save'       => __( 'Test & Save', 'celersearch' ),
		],
		'hints'    => [
			'provider_info' => __( 'Select the search provider you want to connect to.', 'celersearch' ),
			'test_info'     => __( 'Test the connection before saving to ensure everything is configured correctly.', 'celersearch' ),
		],
		'test'     => [
			'button'  => __( 'Test Connection', 'celersearch' ),
			'testing' => __( 'Testing connection...', 'celersearch' ),
			'success' => __( 'Connection successful!', 'celersearch' ),
			'failed'  => __( 'Connection failed', 'celersearch' ),
		],
	],
	'settings' => [
		'title'    => __( 'Settings', 'celersearch' ),
		'sections' => [
			'general'           => __( 'General Settings', 'celersearch' ),
			'contexts'          => __( 'Search Contexts', 'celersearch' ),
			'post_type_mapping' => __( 'Post Type Mapping', 'celersearch' ),
		],
		'labels'   => [
			'enable_search'      => __( 'Enable CelerSearch', 'celersearch' ),
			'default_index'      => __( 'Default Index', 'celersearch' ),
			'fallback_to_native' => __( 'Fallback to Native Search', 'celersearch' ),
			'main_query'         => __( 'Replace Main Search Queries', 'celersearch' ),
			'admin_search'       => __( 'Enable in Admin', 'celersearch' ),
			'rest_api'           => __( 'Enable in REST API', 'celersearch' ),
			'select_post_type'   => __( 'Select Post Type', 'celersearch' ),
			'select_index'       => __( 'Select Index', 'celersearch' ),
			'batch_size'         => __( 'Batch Size', 'celersearch' ),
			'default_sort'       => __( 'Default sort order', 'celersearch' ),
		],
		'hints'    => [
			'general'            => __( 'Configure the basic search settings for CelerSearch.', 'celersearch' ),
			'enable_search'      => __( 'Enable CelerSearch to replace WordPress default search.', 'celersearch' ),
			'default_index'      => __( 'The index to use when no specific mapping is found.', 'celersearch' ),
			'fallback_to_native' => __( 'If enabled, WordPress default search will be used when CelerSearch index is unavailable.', 'celersearch' ),
			'contexts'           => __( 'Choose where CelerSearch should be active.', 'celersearch' ),
			'main_query'         => __( 'Replace the main WordPress search queries with CelerSearch.', 'celersearch' ),
			'admin_search'       => __( 'Enable CelerSearch for admin area searches.', 'celersearch' ),
			'rest_api'           => __( 'Enable CelerSearch for REST API search endpoints.', 'celersearch' ),
			'post_type_mapping'  => __( 'Map specific post types to indices for targeted searching.', 'celersearch' ),
			'batch_size'         => __( 'Number of items to process per batch during indexing (10-500).', 'celersearch' ),
		],
		'buttons'  => [
			'add_mapping' => __( 'Add Mapping', 'celersearch' ),
		],
		'options'  => [
			'none' => __( 'None', 'celersearch' ),
		],
		'table'    => [
			'post_type' => __( 'Post Type', 'celersearch' ),
			'index'     => __( 'Index', 'celersearch' ),
		],
		'empty'    => [
			'no_mappings'      => __( 'No mappings configured', 'celersearch' ),
			'no_mappings_hint' => __( 'Add post type to index mappings using the form above.', 'celersearch' ),
		],
		// Index Settings
		'typo_tolerance'           => __( 'Typo Tolerance', 'celersearch' ),
		'typo_enabled'             => __( 'Enable typo tolerance', 'celersearch' ),
		'typo_enabled_hint'        => __( 'Allow search results to include words with typos.', 'celersearch' ),
		'typo_min_one'             => __( 'Min word size for 1 typo', 'celersearch' ),
		'typo_min_one_hint'        => __( 'Minimum characters for one typo (default: 5).', 'celersearch' ),
		'typo_min_two'             => __( 'Min word size for 2 typos', 'celersearch' ),
		'typo_min_two_hint'        => __( 'Minimum characters for two typos (default: 9).', 'celersearch' ),
		'typo_disable_words'       => __( 'Disable typos on words', 'celersearch' ),
		'typo_disable_words_hint'  => __( 'Words that should match exactly (e.g., API, SDK).', 'celersearch' ),
		'typo_disable_fields'      => __( 'Disable typos on fields', 'celersearch' ),
		'typo_disable_fields_hint' => __( 'Fields where typo tolerance should be disabled (e.g., sku).', 'celersearch' ),
		'stop_words'               => __( 'Stop Words', 'celersearch' ),
		'stop_words_list'          => __( 'Stop words', 'celersearch' ),
		'stop_words_hint'          => __( 'Words to ignore during search (e.g., the, a, an).', 'celersearch' ),
		'load_preset'              => __( 'Load preset', 'celersearch' ),
		'load'                     => __( 'Load', 'celersearch' ),
		'select_language'          => __( 'Select language...', 'celersearch' ),
		'add_word'                 => __( 'Add word...', 'celersearch' ),
		'add_field'                => __( 'Add field...', 'celersearch' ),
		'result_limits'            => __( 'Result Limits', 'celersearch' ),
		'max_hits'                 => __( 'Max total hits', 'celersearch' ),
		'max_hits_hint'            => __( 'Maximum results returned (default: 1000).', 'celersearch' ),
		'facet_max_values'         => __( 'Max facet values', 'celersearch' ),
		'facet_max_values_hint'    => __( 'Maximum values per facet (default: 100).', 'celersearch' ),
		'ranking_rules'            => __( 'Ranking Rules', 'celersearch' ),
		'ranking_rules_hint'       => __( 'Drag to reorder how search results are ranked.', 'celersearch' ),
		'reset_to_default'         => __( 'Reset to default', 'celersearch' ),
		'proximity_precision'      => __( 'Word Proximity', 'celersearch' ),
		'precision'                => __( 'Precision', 'celersearch' ),
		'proximity_precision_hint' => __( 'How word proximity affects relevance.', 'celersearch' ),
		'proximity_by_word'        => __( 'By Word (more relevant, slower)', 'celersearch' ),
		'proximity_by_attribute'   => __( 'By Attribute (faster, less precise)', 'celersearch' ),
		'saved'                    => __( 'Settings saved successfully.', 'celersearch' ),
		'index_settings'           => __( 'Index Settings', 'celersearch' ),
		'index_settings_subtitle'  => __( 'Configure search behavior for this index.', 'celersearch' ),
	],
	'views'    => [
		'title'        => __( 'Views', 'celersearch' ),
		'create'       => __( 'Create View', 'celersearch' ),
		'edit'         => __( 'Update View', 'celersearch' ),
		'subtitle'     => __( 'Configure a reusable search view', 'celersearch' ),
		'sections'     => [
			'basic_info'           => __( 'Basic Information', 'celersearch' ),
			'basic_info_hint'      => __( 'Name your view and select which index to search', 'celersearch' ),
			'search_behavior'      => __( 'Search Behavior', 'celersearch' ),
			'search_behavior_hint' => __( 'Configure how searches are triggered and processed', 'celersearch' ),
			'display_options'      => __( 'Display Options', 'celersearch' ),
			'display_options_hint' => __( 'Control result display, pagination, and highlighting', 'celersearch' ),
			'filter_groups'        => __( 'Filter Groups', 'celersearch' ),
			'filter_groups_hint'   => __( 'Control which filter groups are visible', 'celersearch' ),
			'advanced'             => __( 'Advanced', 'celersearch' ),
			'advanced_hint'        => __( 'Additional customization options', 'celersearch' ),
		],
		'labels'       => [
			'id'                      => __( 'ID', 'celersearch' ),
			'name'                    => __( 'Name', 'celersearch' ),
			'index'                   => __( 'Index', 'celersearch' ),
			'type'                    => __( 'Type', 'celersearch' ),
			'shortcode'               => __( 'Shortcode', 'celersearch' ),
			'created_at'              => __( 'Created At', 'celersearch' ),
			'config_section'          => __( 'View Configuration', 'celersearch' ),
			'limit'                   => __( 'Results per page', 'celersearch' ),
			'placeholder'             => __( 'Search placeholder', 'celersearch' ),
			'mode'                    => __( 'Search mode', 'celersearch' ),
			'initial_display'         => __( 'Initial display', 'celersearch' ),
			'debounce'                => __( 'Debounce (ms)', 'celersearch' ),
			'min_chars'               => __( 'Min characters', 'celersearch' ),
			'show_facets'             => __( 'Show facets', 'celersearch' ),
			'highlight'               => __( 'Highlight matches', 'celersearch' ),
			'css_class'               => __( 'CSS class', 'celersearch' ),
			'show_all_filters'        => __( 'Show all filter groups', 'celersearch' ),
			'select_specific_filters' => __( 'Select specific groups', 'celersearch' ),
			'disable_filters'         => __( 'Disable filters', 'celersearch' ),
			'filter_groups'           => __( 'Filter Groups', 'celersearch' ),
			'default_sort'            => __( 'Default sort order', 'celersearch' ),
		],
		'placeholders' => [
			'name'      => __( 'e.g. Blog Search', 'celersearch' ),
			'search'    => __( 'Search...', 'celersearch' ),
			'css_class' => __( 'Optional CSS class', 'celersearch' ),
		],
		'modes'        => [
			'live'   => __( 'Live (search as you type)', 'celersearch' ),
			'submit' => __( 'On submit', 'celersearch' ),
		],
		'initial_display' => [
			'search_only' => __( 'Search only (empty until user searches)', 'celersearch' ),
			'browse'      => __( 'Browse (show results on page load)', 'celersearch' ),
		],
		'sort_options'  => [
			'relevance'  => __( 'Default (by relevance)', 'celersearch' ),
			'date'       => __( 'Newest first', 'celersearch' ),
			'date_asc'   => __( 'Oldest first', 'celersearch' ),
			'title'      => __( 'Title (A-Z)', 'celersearch' ),
			'title_desc' => __( 'Title (Z-A)', 'celersearch' ),
		],
		'actions'      => [
			'copy_shortcode' => __( 'Copy shortcode', 'celersearch' ),
		],
		'messages'     => [
			'shortcode_copied'       => __( 'Shortcode copied to clipboard!', 'celersearch' ),
			'select_index_first'     => __( 'Please select an index first to see available filter groups.', 'celersearch' ),
			'loading_filters'        => __( 'Loading available filter groups...', 'celersearch' ),
			'no_filters_available'   => __( 'No filterable attributes configured for this index.', 'celersearch' ),
		],
		'hints'        => [
			'filter_groups' => __( 'Select which filter groups to show. Order determines display order.', 'celersearch' ),
		],
	]
];