<?php

namespace CelerSearch\Admin\Lists;

use CelerSearch\Indices\BaseIndex;
use CelerSearch\Repositories\ServiceRepository;

class Services extends \WP_List_Table {

	protected $date_format;
	protected $time_format;

	/**
	 * Constructor
	 */
	public function __construct() {

		$this->date_format = get_option( 'date_format' );
		$this->time_format = get_option( 'time_format' );

		parent::__construct( array(
			'singular' => 'service',
			'plural'   => 'services',
			'ajax'     => false,
		) );
	}

	/**
	 * The columns
	 * @return array
	 */
	public function get_columns() {
		return array(
			'name'    => __( 'Name', 'celersearch' ),
			'status'  => __( 'Type', 'celersearch' ),
			'date'    => __( 'Date', 'celersearch' ),
			'actions' => __( 'Actions', 'celersearch' ),
		);
	}

	/**
	 * The actions column
	 *
	 * @param  object  $item
	 *
	 * @return string
	 */
	protected function column_name( $item ) {
		return ucfirst( $item->name );
	}

	/**
	 * The actions column
	 *
	 * @param  object  $item
	 *
	 * @return string
	 */
	protected function column_status( $item ) {
		return 'OK';
	}

	/**
	 * The service column
	 *
	 * @param  object  $item
	 *
	 * @return string
	 */
	protected function column_date( $item ) {
		$date = \DateTime::createFromFormat( 'Y-m-d H:i:s', $item->created_at, new \DateTimeZone( 'UTC' ) );
		if ( ! $date ) {
			return __( 'Unknown', 'celersearch' );
		}

		return $date->setTimezone( wp_timezone() )->format( $this->date_format . ' @ ' . $this->time_format );
	}

	/**
	 * The actions column
	 *
	 * @param  object  $item
	 *
	 * @return string
	 */
	protected function column_actions( $item ) {
		return '<a class="button-secondary button-small" href="">' . __( 'Settings', 'celersearch' ) . '</a>';
	}

	/**
	 * Prepare items
	 * @return void
	 */
	public function prepare_items() {
		$per_page              = 5;
		$columns               = $this->get_columns();
		$hidden                = array();
		$sortable              = $this->get_sortable_columns();
		$this->_column_headers = array( $columns, $hidden, $sortable );

	}

	/**
	 * Disable table nav
	 *
	 * @param $which
	 *
	 * @return void
	 */
	protected function display_tablenav( $which ) {
	}
}