<?php

namespace CelerSearch\Admin;

defined( 'ABSPATH' ) || exit;

use CelerSearch\Admin\Lists\Indices;
use CelerSearch\Admin\Lists\Services;
use CelerSearch\Interfaces\IRegistrable;
use CelerSearch\Manager;

class Boot implements IRegistrable {

	protected Manager $manager;
	protected array $components = [];
	protected Assets $assets;
	protected Ajax $ajax;

	/**
	 * The Construcotr
	 *
	 * @param Manager $manager
	 */
	public function __construct( $manager ) {
		$this->manager = $manager;

		$this->components['ajax']   = new Ajax( $manager );
		$this->components['assets'] = new Assets();
	}

	/**
	 * Registers certain group of hooks (actions/filters)
	 * @return void
	 */
	public function register(): void {
		add_action( 'admin_menu', [ $this, 'admin_menu' ] );

		foreach ( $this->components as $component ) {
			$component->register();
		}

	}

	/**
	 * Registers the admin menus
	 * @return void
	 */
	public function admin_menu() {
		global $submenu;
		$capability = 'manage_options';
		$slug       = 'celersearch';

		$icon_svg = '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20">'
			. '<rect x="0" y="3.5" width="4.5" height="1.5" rx="0.75" fill="#a7aaad" opacity="0.6"/>'
			. '<rect x="0.5" y="7.5" width="6" height="1.5" rx="0.75" fill="#a7aaad" opacity="0.8"/>'
			. '<rect x="0" y="11.5" width="4.5" height="1.5" rx="0.75" fill="#a7aaad" opacity="0.6"/>'
			. '<circle cx="12.5" cy="8.5" r="5" fill="none" stroke="#a7aaad" stroke-width="1.5"/>'
			. '<line x1="16" y1="12" x2="19.5" y2="15.5" stroke="#a7aaad" stroke-width="2" stroke-linecap="round"/>'
			. '</svg>';
		$icon_url = 'data:image/svg+xml;base64,' . base64_encode( $icon_svg );

		$hook = add_menu_page(
			__( 'Indices', 'celersearch' ),
			__( 'CelerSearch', 'celersearch' ),
			'manage_options',
			$slug,
			[ $this, 'render_page' ],
			$icon_url,
			99
		);

		$submenu[ $slug ][] = array( __( 'Indices', 'celersearch' ), $capability, 'admin.php?page=' . $slug . '#/' );
		$submenu[ $slug ][] = array( __( 'Views', 'celersearch' ), $capability, 'admin.php?page=' . $slug . '#/views' );
		$submenu[ $slug ][] = array( __( 'Services', 'celersearch' ), $capability, 'admin.php?page=' . $slug . '#/services' );
		$submenu[ $slug ][] = array( __( 'Settings', 'celersearch' ), $capability, 'admin.php?page=' . $slug . '#/settings' );

	}

	/**
	 * The API keys page
	 * @return void
	 */
	public function render_page() {
		echo '<div class="wrap"><div id="celersearch-admin"></div></div>';
	}
}