<?php

namespace CelerSearch\Abstracts;

use CelerSearch\Interfaces\IIndexableObject;

abstract class IndexableObject implements IIndexableObject {

	/**
	 * The unique identifier of the indexable object
	 * @var string
	 */
	protected string $id;

	/**
	 * The indexable data bits of the object
	 * @var array
	 */
	protected array $data;

	/**
	 * Constructor
	 * @param $id
	 * @param $data
	 */
	public function __construct( string $id, array $data ) {
		$this->id   = $id;
		$this->data = $data;
	}

	/**
	 * Returns the id
	 * @return string
	 */
	public function get_id() : string {
		return $this->id;
	}

	/**
	 * Returns the data
	 * @return array
	 */
	public function get_indexable_data() : array {
		return $this->data;
	}
}