<?php

namespace CelerSearch\Abstracts;

use CelerSearch\Interfaces\IBuilderObject;

abstract class IndexResponse implements IBuilderObject {

	/**
	 * The response code
	 * @var int
	 */
	protected int $response_code;

	/**
	 * The response body
	 * @var array
	 */
	protected array $response_body;

	/**
	 * The async task ID (if applicable)
	 * @var string|null
	 */
	protected ?string $task_id = null;

	/**
	 * The async task object (provider-specific)
	 * @var mixed
	 */
	protected mixed $task_object = null;

	/**
	 * Get the response code
	 * @param int $response_code
	 *
	 * @return void
	 */
	public function set_response_code( int $response_code ) : void {
		$this->response_code = $response_code;
	}

	/**
	 * Get the response body
	 * @param array $response_body
	 *
	 * @return void
	 */
	public function set_response_body( array $response_body ) : void {
		$this->response_body = $response_body;
	}

	/**
	 * Is error response?
	 * @return bool
	 */
	public abstract function is_error_response() : bool;

	/**
	 * Get the task ID
	 * @return string|null
	 */
	public function get_task_id(): ?string {
		return $this->task_id;
	}

	/**
	 * Set the task ID
	 * @param string|null $task_id
	 *
	 * @return void
	 */
	public function set_task_id( ?string $task_id ): void {
		$this->task_id = $task_id;
	}

	/**
	 * Get the task object
	 * @return mixed
	 */
	public function get_task_object(): mixed {
		return $this->task_object;
	}

	/**
	 * Set the task object
	 * @param mixed $task_object
	 *
	 * @return void
	 */
	public function set_task_object( mixed $task_object ): void {
		$this->task_object = $task_object;
	}

	/**
	 * Check if this response has task info for async operations
	 * @return bool
	 */
	public function has_task(): bool {
		return $this->task_id !== null || $this->task_object !== null;
	}

}