<?php
/**
 * Plugin Name:       CelerSearch
 * Plugin URI:        https://celersearch.com/
 * Description:       Extends WordPress search with a powerful MeiliSearch integration
 * Version:           1.2.3
 * Author:            CelerSearch
 * Author URI:        https://celersearch.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       celersearch
 * Domain Path:       /languages
 * Requires at least: 6.0
 * Requires PHP:      8.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	die;
}

define( 'CELERSEARCH_PLUGIN_VERSION', '1.2.3' );
define( 'CELERSEARCH_PLUGIN_PATH', rtrim( plugin_dir_path( __FILE__ ), DIRECTORY_SEPARATOR ) . DIRECTORY_SEPARATOR );
define( 'CELERSEARCH_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

if ( ! file_exists( CELERSEARCH_PLUGIN_PATH . 'vendor/autoload.php' ) ) {
	add_action( 'admin_notices', function () {
		printf(
			'<div class="%1$s"><p>%2$s</p></div>',
			'notice notice-error',
			'You are running development versio of <strong>CelerSearch</strong>, please download the plugin from WordPress.org in order to be able to use it.'
		);
	} );

	return;
}

// Load scoped (prefixed) vendor dependencies first
if ( file_exists( CELERSEARCH_PLUGIN_PATH . 'vendor_prefixed/vendor/autoload.php' ) ) {
	require_once CELERSEARCH_PLUGIN_PATH . 'vendor_prefixed/vendor/autoload.php';
}

require_once CELERSEARCH_PLUGIN_PATH . 'vendor/autoload.php';

// Initialize Action Scheduler if bundled (for sites without WooCommerce)
if ( file_exists( CELERSEARCH_PLUGIN_PATH . 'vendor/woocommerce/action-scheduler/action-scheduler.php' ) ) {
	require_once CELERSEARCH_PLUGIN_PATH . 'vendor/woocommerce/action-scheduler/action-scheduler.php';
}

// Initialize plugin on plugins_loaded hook
add_action( 'plugins_loaded', function () {
	$GLOBALS['celersearch'] = new \CelerSearch\Boot();
	$GLOBALS['celersearch']->register();
}, 10 );

// Register WP-CLI commands.
if ( defined( 'WP_CLI' ) && WP_CLI ) {
	WP_CLI::add_command( 'celersearch reindex', \CelerSearch\CLI\ReindexCommand::class );
	WP_CLI::add_command( 'celersearch index', \CelerSearch\CLI\IndexCommand::class );
	WP_CLI::add_command( 'celersearch service', \CelerSearch\CLI\ServiceCommand::class );
}

