(function(){class e{constructor(e,t={}){this.input=e,this.options={debounce:300,minChars:2,maxResults:5,indexId:0,context:"frontend",restUrl:"",nonce:"",templates:{},i18n:{},...t},this.dropdown=null,this.results=[],this.selectedIndex=-1,this.abortController=null,this.isOpen=!1,this.debounceTimer=null,this.init()}init(){this.createDropdown(),this.bindEvents(),this.setAriaAttributes()}createDropdown(){this.dropdown=document.createElement("div"),this.dropdown.className="celersearch-autocomplete",this.dropdown.setAttribute("role","listbox"),this.dropdown.setAttribute("aria-label",this.options.i18n.resultsLabel||"Search results"),this.dropdown.hidden=!0,this.wrapper=document.createElement("div"),this.wrapper.className="celersearch-autocomplete-wrapper",this.wrapper.style.position="relative",this.wrapper.style.display="inline-block",this.input.parentNode.insertBefore(this.wrapper,this.input),this.wrapper.appendChild(this.input),this.wrapper.appendChild(this.dropdown)}setAriaAttributes(){this.input.setAttribute("role","combobox"),this.input.setAttribute("aria-autocomplete","list"),this.input.setAttribute("aria-expanded","false"),this.input.setAttribute("aria-haspopup","listbox"),this.input.setAttribute("autocomplete","off")}bindEvents(){this.input.addEventListener("input",()=>this.handleInput()),this.input.addEventListener("focus",()=>this.handleFocus()),this.input.addEventListener("keydown",e=>this.handleKeydown(e)),document.addEventListener("click",e=>this.handleOutsideClick(e)),document.addEventListener("keydown",e=>{"Escape"===e.key&&this.isOpen&&(this.close(),this.input.focus())});const e=this.input.closest("form");e&&e.addEventListener("submit",()=>this.close())}handleInput(){const e=this.input.value.trim();this.debounceTimer&&clearTimeout(this.debounceTimer),e.length<this.options.minChars?this.close():this.debounceTimer=setTimeout(()=>{this.search(e)},this.options.debounce)}handleFocus(){this.input.value.trim().length>=this.options.minChars&&this.results.length>0&&this.open()}handleOutsideClick(e){this.input.contains(e.target)||this.dropdown.contains(e.target)||this.close()}handleKeydown(e){if(this.isOpen)switch(e.key){case"ArrowDown":e.preventDefault(),this.moveSelection(1);break;case"ArrowUp":e.preventDefault(),this.moveSelection(-1);break;case"Enter":this.selectedIndex>=0&&(e.preventDefault(),this.selectResult(this.selectedIndex));break;case"Tab":this.close()}}async search(e){this.abortController&&this.abortController.abort(),this.abortController=new AbortController,this.showLoading();try{const t=new URL(this.options.restUrl,window.location.origin);t.searchParams.set("q",e),t.searchParams.set("index_id",this.options.indexId),t.searchParams.set("limit",this.options.maxResults),t.searchParams.set("context",this.options.context);const s=await fetch(t.toString(),{method:"GET",headers:{"X-WP-Nonce":this.options.nonce},signal:this.abortController.signal}),i=await s.json();i.success&&i.data.hits.length>0?(this.results=i.data.hits,this.render(e,i.data.total),this.open()):(this.results=[],this.renderEmpty(e),this.open())}catch(t){"AbortError"!==t.name&&(console.error("CelerSearch autocomplete error:",t),this.close())}}showLoading(){this.dropdown.innerHTML=`\n            <div class="celersearch-autocomplete__loading">\n                <span class="celersearch-autocomplete__loading-spinner"></span>\n                <span>${this.options.i18n.searching||"Searching..."}</span>\n            </div>\n        `,this.open()}render(e,t){const s=this.results.map((e,t)=>this.renderSuggestion(e,t)).join("");let i=this.options.templates.container||'<ul class="celersearch-autocomplete__list">{{suggestions}}</ul>';i=this.replaceTemplateVars(i,{suggestions:s,query:this.escapeHtml(e),total:t}),this.dropdown.innerHTML=i,this.selectedIndex=-1,this.bindSuggestionEvents()}renderSuggestion(e,t){let s=this.options.templates.suggestion||this.getDefaultSuggestionTemplate();const i=e._formatted?.title||this.escapeHtml(e.title),n=e._formatted?.content||e._formatted?.excerpt||this.escapeHtml(e.excerpt),r=!!e.thumbnail,o=!!e.edit_url,a="admin"===this.options.context,l=e.variations&&e.variations.length>0;s=this.processConditionals(s,{thumbnail:r,edit_url:o&&a,show_actions:a,variations:l});let c=this.replaceTemplateVars(s,{index:t,id:e.id,post_type:e.post_type,post_type_label:this.escapeHtml(e.post_type_label),title:i,excerpt:n,url:e.url,edit_url:e.edit_url||"",thumbnail:e.thumbnail||""});return l&&(c+=this.renderVariations(e.variations,e.url)),c}renderVariations(e,t){const s=e.slice(0,3),i=e.length-3;let n='<ul class="celersearch-autocomplete__variations">';return s.forEach(e=>{const t=e.in_stock?"":"celersearch-autocomplete__variation--out-of-stock",s=this.escapeHtml(e.title),i=e.price_html||"";n+=`\n                <li class="celersearch-autocomplete__variation ${t}">\n                    <a href="${e.permalink}">\n                        <span class="celersearch-autocomplete__variation-title">${s}</span>\n                        <span class="celersearch-autocomplete__variation-price">${i}</span>\n                    </a>\n                </li>\n            `}),i>0&&(n+=`\n                <li class="celersearch-autocomplete__variation celersearch-autocomplete__variation--more">\n                    <a href="${t}">+${i} ${this.options.i18n.moreOptions||"more options"}</a>\n                </li>\n            `),n+="</ul>",n}getDefaultSuggestionTemplate(){return'\n            <li class="celersearch-autocomplete__item" role="option" data-suggestion-index="{{index}}">\n                <a href="{{url}}" class="celersearch-autocomplete__link">\n                    <div class="celersearch-autocomplete__content">\n                        <span class="celersearch-autocomplete__post-type">{{post_type_label}}</span>\n                        <span class="celersearch-autocomplete__title">{{title}}</span>\n                        <p class="celersearch-autocomplete__excerpt">{{excerpt}}</p>\n                    </div>\n                </a>\n            </li>\n        '}renderEmpty(e){let t=this.options.templates.empty||`\n            <div class="celersearch-autocomplete__empty">\n                <p>${this.options.i18n.noResults||'No results found for "{{query}}"'}</p>\n            </div>\n        `;t=this.replaceTemplateVars(t,{query:this.escapeHtml(e)}),this.dropdown.innerHTML=t,this.selectedIndex=-1}replaceTemplateVars(e,t){return e.replace(/\{\{(\w+)\}\}/g,(e,s)=>void 0!==t[s]?t[s]:e)}processConditionals(e,t){let s,i=10;do{s=e,e=(e=e.replace(/\{\{#(\w+)\}\}([\s\S]*?)\{\{\/\1\}\}/g,(e,s,i)=>t[s]?i:"")).replace(/\{\{\^(\w+)\}\}([\s\S]*?)\{\{\/\1\}\}/g,(e,s,i)=>t[s]?"":i),i--}while(e!==s&&i>0);return e}bindSuggestionEvents(){this.dropdown.querySelectorAll("[data-suggestion-index]").forEach(e=>{e.addEventListener("click",t=>{if(t.target.closest("a"))return void this.close();t.preventDefault();const s=parseInt(e.dataset.suggestionIndex,10);this.selectResult(s)}),e.addEventListener("mouseenter",()=>{const t=parseInt(e.dataset.suggestionIndex,10);this.setSelection(t)})})}moveSelection(e){const t=this.results.length-1;let s=this.selectedIndex+e;s<0?s=t:s>t&&(s=0),this.setSelection(s)}setSelection(e){const t=this.dropdown.querySelectorAll("[data-suggestion-index]");t.forEach(e=>{e.classList.remove("celersearch-autocomplete__item--selected"),e.setAttribute("aria-selected","false")}),this.selectedIndex=e,e>=0&&t[e]&&(t[e].classList.add("celersearch-autocomplete__item--selected"),t[e].setAttribute("aria-selected","true"),t[e].scrollIntoView({block:"nearest"}),this.input.setAttribute("aria-activedescendant",t[e].id||""))}selectResult(e){const t=this.results[e];t&&t.url&&(window.location.href=t.url)}open(){this.dropdown.hidden=!1,this.isOpen=!0,this.input.setAttribute("aria-expanded","true"),this.input.dispatchEvent(new CustomEvent("celersearch:open",{detail:{autocomplete:this}}))}close(){this.dropdown.hidden=!0,this.isOpen=!1,this.selectedIndex=-1,this.input.setAttribute("aria-expanded","false"),this.input.removeAttribute("aria-activedescendant"),this.input.dispatchEvent(new CustomEvent("celersearch:close",{detail:{autocomplete:this}}))}escapeHtml(e){if(!e)return"";const t=document.createElement("div");return t.textContent=e,t.innerHTML}destroy(){this.dropdown&&this.dropdown.parentNode&&this.dropdown.parentNode.removeChild(this.dropdown),this.wrapper&&this.wrapper.parentNode&&(this.wrapper.parentNode.insertBefore(this.input,this.wrapper),this.wrapper.parentNode.removeChild(this.wrapper)),this.input.removeAttribute("role"),this.input.removeAttribute("aria-autocomplete"),this.input.removeAttribute("aria-expanded"),this.input.removeAttribute("aria-haspopup"),this.input.removeAttribute("aria-activedescendant"),this.debounceTimer&&clearTimeout(this.debounceTimer),this.abortController&&this.abortController.abort(),delete this.input.dataset.celerSearchInitialized}}function t(){const t=window.celerSearchAutocomplete||{},s=t.areas||[];s.length&&s.forEach(s=>{if(!s.selector)return;document.querySelectorAll(s.selector).forEach(i=>{i.dataset.celerSearchInitialized||(new e(i,{...s,restUrl:t.restUrl,nonce:t.nonce,templates:t.templates||{},i18n:t.i18n||{}}),i.dataset.celerSearchInitialized="true")})})}function s(){t()}"loading"===document.readyState?document.addEventListener("DOMContentLoaded",t):t(),document.addEventListener("celersearch:reinit",s),document.addEventListener("ajaxComplete",s),window.CelerSearchAutocomplete={init:t,reinit:s,SearchAutocomplete:e};
})();
