<?php

/**
 * Triggered when the plugin is uninstalled.
 * 
 * @link       https://www.rapidspike.com/cartshark
 * @since      1.0.0
 *
 * @package    CartShark
 * @subpackage CartShark/includes
 */

// If uninstall not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Check if user opted to delete plugin data.
$delete_data = get_option( 'cartshark_delete_data_on_uninstall', false );
if ( ! $delete_data ) {
    return;
}

// Clean up all plugin data.
global $wpdb;

// Delete plugin-specific options.
$plugin_options = [
    'cartshark_api_key_public',
    'cartshark_api_key_private',
    'cartshark_user_email',
    'cartshark_account_id',
    'cartshark_website_uuid',
    'cartshark_tracker_enabled',
    'cartshark_delete_data_on_uninstall',
    'cartshark_plugin_version',
    'cartshark_subscription_status',
];

foreach ( $plugin_options as $option ) {
    delete_option( $option );
}

// Delete plugin transients.
delete_transient( 'cartshark_tracker_status' );
delete_transient( 'cartshark_api_cache' );