<?php
/**
 * The public-facing functionality of the plugin.
 *
 * @since      1.0.0
 * @package    CartShark
 * @subpackage CartShark/public
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class CartShark_Public {

    /**
     * The plugin ID.
     *
     * @since 1.0.0
     * @access private
     * @var string $plugin_name The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The plugin version.
     *
     * @since 1.0.0
     * @access private
     * @var string $version The current version of this plugin.
     */
    private $version;

    /**
     * Constructor
     *
     * @param string $plugin_name The name of the plugin.
     * @param string $version The version of the plugin.
     */
    public function __construct( $plugin_name, $version ) {
        $this->plugin_name = $plugin_name;
        $this->version     = $version;

        // Load required classes.
        if ( ! class_exists( 'CartShark_Tracker' ) ) {
            require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-cartshark-tracker.php';
        }
    }

    /**
     * Register the stylesheets for the public-facing side of the site.
     *
     * @since 1.0.0
     */
    public function enqueue_styles() {
        wp_enqueue_style(
            $this->plugin_name . '-public',
            plugin_dir_url( __FILE__ ) . 'css/cartshark-public.css',
            array(),
            $this->version,
            'all'
        );
    }

    /**
     * Register the JavaScript for the public-facing side of the site.
     *
     * @since 1.0.0
     */
    public function enqueue_scripts() {
        wp_enqueue_script(
            $this->plugin_name . '-public',
            plugin_dir_url( __FILE__ ) . 'js/cartshark-public.js',
            array( 'jquery' ),
            $this->version,
            true
        );
    }

    /**
     * Injects the CartShark tracker code into the <head>.
     *
     * @since 1.0.0
     */
    public function inject_tracker_code() {

        $tracker_enabled = get_option('cartshark_tracker_enabled', '1') === '1';

        if (!$tracker_enabled) {
            return; // Do not inject tracker if disabled
        }

        $tracker = new CartShark_Tracker();

        if ( $tracker->is_tracker_present() ) {

            // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Safe, hard-coded inline JS tracker
            echo $tracker->insert_tracker_code();
        }
        
    }
}
