<?php
/**
 * CartShark WooCommerce Integration
 *
 * Declares compatibility with WooCommerce features such as HPOS and Payments Settings beta.
 *
 * @since      1.0.0
 * @package    CartShark
 * @subpackage CartShark/includes
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class CartShark_WooCommerce {

    public function __construct() {
        // Hook into before_woocommerce_init to declare compatibility at the right time
        add_action( 'before_woocommerce_init', array( $this, 'declare_compatibility' ) );
    }

    public function declare_compatibility() {
        if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility(
                'custom_order_tables',
                plugin_basename( CARTSHARK_PLUGIN_FILE ),
                true
            );

            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility(
                'cart_checkout_blocks',
                plugin_basename( CARTSHARK_PLUGIN_FILE ),
                true
            );
        }
    }

    public function init() {
        // additional wc hooks if needed
    }
}
