<?php
/**
 * CartShark - Web-Skimming Detection for WooCommerce
 *
 * @package           CartShark
 * @author            RapidSpike
 * @copyright         2025 CartShark, a RapidSpike brand
 * @license           GPL-2.0-or-later
 *
 * @wordpress-plugin
 * Plugin Name:       CartShark Security
 * Plugin URI:        https://cartshark.rapidspike.com
 * Description:       Advanced web-skimming detection and protection for WooCommerce and other WordPress ecommerce platforms
 * Version:           1.0.15
 * Requires at least: 5.8
 * Requires PHP:      7.4
 * Author:            RapidSpike / CartShark Team
 * Author URI:        https://www.rapidspike.com/cartshark
 * Text Domain:       cartshark-security
 * License:           GPL v2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * 
 * WC requires at least: 5.0
 * WC tested up to:      7.5
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('CARTSHARK_VERSION', '1.0.15');
define('CARTSHARK_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('CARTSHARK_PLUGIN_URL', plugin_dir_url(__FILE__));
define('CARTSHARK_PLUGIN_BASENAME', plugin_basename(__FILE__));
define('CARTSHARK_PLUGIN_FILE', __FILE__);
define('CARTSHARK_API_URL', 'https://api.rapidspike.com');
define('CARTSHARK_APP_URL', 'https://cartshark.rapidspike.com');

// Load Activator/Deactivator early for hooks
require_once CARTSHARK_PLUGIN_DIR . 'includes/class-cartshark-activator.php';
require_once CARTSHARK_PLUGIN_DIR . 'includes/class-cartshark-deactivator.php';

// Register hooks (needs class loaded first)
register_activation_hook( __FILE__, function() {
    CartShark_Activator::activate();
});

register_deactivation_hook( __FILE__, function() {
    CartShark_Deactivator::deactivate();
});

/**
 * The main function responsible for returning the one true CartShark instance.
 *
 * @since 1.0.0
 * @return void
 * 
 */
function cartshark_security_run_plugin() {

    // Load core files
    require_once CARTSHARK_PLUGIN_DIR . 'includes/class-cartshark.php';
    require_once CARTSHARK_PLUGIN_DIR . 'includes/class-cartshark-loader.php';
    require_once CARTSHARK_PLUGIN_DIR . 'includes/class-cartshark-api.php';
    require_once CARTSHARK_PLUGIN_DIR . 'includes/class-cartshark-tracker.php';
    
    // Admin
    require_once CARTSHARK_PLUGIN_DIR . 'admin/class-cartshark-admin.php';

    // Public
    require_once CARTSHARK_PLUGIN_DIR . 'public/class-cartshark-public.php';

    $cartshark = new CartShark();
    $cartshark->init();
    $cartshark->run();
}
add_action( 'plugins_loaded', 'cartshark_security_run_plugin' );