<?php
/**
 * Template for onboarding completion page
 *
 * Available variables:
 * $dashboard_url - URL to the dashboard
 *
 * @since      1.0.0
 * @package CartShark
 * @subpackage CartShark/admin/partials
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="cartshark-admin-wrap">

    <div class="cartshark-header">

        <?php $this->load_template('cartshark-logo.php'); ?>

        <h1>You're Almost Set Up</h1>
        <p>We’ve connected your account, but setup isn’t complete yet.</p>

    </div>
    
    <div id="cartshark-pending-container">

        <!-- Redirect -->
        <section class="cartshark-tab-content active">

            <p class="m-t-0">Click <strong>Complete Setup</strong> to visit the CartShark app and finish onboarding your site.</p>

            <div class="gd gd--gap-20">

                <a href="<?php echo esc_url($continue_url); ?>" class="button button-primary">
                    Complete Setup
                </a>

                <button id="logout-btn" class="button button-danger-inverted">
                    Log out
                </button>

            </div>

        </div>

    </div>
</div>
