<?php
/**
 * Template for the dashboard page
 *
 * Available variables:
 * $user_data - Array of user data from API
 * $cartshark_url - The CartShark app URL
 *
 * @since      1.0.0
 * @package CartShark
 * @subpackage CartShark/admin/partials
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

?>


<div class="cartshark-admin-wrap">

    <div class="cartshark-header">

        <header>
            <?php $this->load_template('cartshark-logo.php'); ?>
            <?php include plugin_dir_path(__FILE__) . 'cartshark-actions.php'; ?>
        </header>

        <h1>Settings</h1>
        <p>Visit the CartShark app to manage your full account, billing and product settings.</p>

    </div>
    
    <section id="cartshark-settings-container">

        <form method="post" action="options.php">

            <?php
            settings_fields('cartshark_settings_group');
            do_settings_sections('cartshark-settings');
            ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Enable Tracker Script</th>
                    <td>
                        <!-- Hidden fallback: always sends a value -->
                        <input type="hidden" name="cartshark_tracker_enabled" value="0" />
                        <input type="checkbox" name="cartshark_tracker_enabled" value="1" <?php checked('1', $tracker_enabled); ?> />
                        <p class="description">Toggle to embed the tracker script on your site.</p>
                    </td>
                </tr>
            </table>
            
            <p class="submit">
                <?php submit_button(); ?>
            </p>

        </form>

    </section>

</div>