<?php
/**
 * Template for error pages
 *
 * Available variables:
 * $error_message - The error message to display
 * $retry_url - URL to retry the action
 *
 * @since      1.0.0
 * @package CartShark
 * @subpackage CartShark/admin/partials
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="cartshark-admin-wrap">

    <div class="cartshark-header">

        <header>
            <?php $this->load_template('cartshark-logo.php'); ?>
        </header>
        
        <h1>An Error Occured</h1>

    </div>
    
    <div id="cartshark-pending-container">

        <!-- Redirect -->
        <div class="cartshark-tab-content active">

            <div class="cartshark-message cartshark-error">
                <svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="M16 2.667C8.648 2.667 2.667 8.648 2.667 16S8.648 29.333 16 29.333 29.333 23.352 29.333 16 23.352 2.667 16 2.667zm4.943 16.39A1.332 1.332 0 0 1 20 21.333a1.33 1.33 0 0 1-.943-.39L16 17.885l-3.057 3.058a1.33 1.33 0 0 1-1.886 0 1.332 1.332 0 0 1 0-1.886L14.115 16l-3.058-3.057a1.332 1.332 0 0 1 0-1.886 1.332 1.332 0 0 1 1.886 0L16 14.115l3.057-3.058a1.332 1.332 0 0 1 1.886 0 1.332 1.332 0 0 1 0 1.886L17.885 16l3.058 3.057z"/></svg>
                <p><?php echo esc_html($error_message); ?></p>
            </div>

            <div class="gd gd--gap-20">

                <a href="<?php echo esc_url($retry_url); ?>" class="button button-primary">Try Again</a>

                <button id="logout-btn" class="button button-danger-inverted">
                    Log out
                </button>

            </div>

        </div>

    </div>
</div>