<?php
/**
 * Template for the dashboard page
 *
 * Available variables:
 * $user_data - Array of user data from API
 * $cartshark_url - The CartShark app URL
 *
 * @since      1.0.0
 * @package CartShark
 * @subpackage CartShark/admin/partials
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

?>

<div class="cartshark-admin-wrap" id="cartshark-dashboard">

    <div class="cartshark-header">

        <header>
            <?php $this->load_template('cartshark-logo.php'); ?>
            <?php include plugin_dir_path(__FILE__) . 'cartshark-actions.php'; ?>
        </header>

        <h1>Overview</h1>
        <p>View high-level account stats here. For much more data visit the CartShark app.</p>

    </div>
    
    <div id="cartshark-dashboard-container">

        <?php if (!$tracker_enabled): ?>
            <div class="cartshark-message cartshark-error">
                <svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="M16 2.667C8.648 2.667 2.667 8.648 2.667 16S8.648 29.333 16 29.333 29.333 23.352 29.333 16 23.352 2.667 16 2.667zm4.943 16.39A1.332 1.332 0 0 1 20 21.333a1.33 1.33 0 0 1-.943-.39L16 17.885l-3.057 3.058a1.33 1.33 0 0 1-1.886 0 1.332 1.332 0 0 1 0-1.886L14.115 16l-3.058-3.057a1.332 1.332 0 0 1 0-1.886 1.332 1.332 0 0 1 1.886 0L16 14.115l3.057-3.058a1.332 1.332 0 0 1 1.886 0 1.332 1.332 0 0 1 0 1.886L17.885 16l3.058 3.057z"/></svg>
                <p>The tracker script is currently <strong>disabled</strong>. <a href="<?php echo esc_url( admin_url('admin.php?page=cartshark-settings') ); ?>">Enable it in Settings</a>.</p>

            </div>
        <?php endif; ?>

        <div class="gd gd--thirds">

            <section class="item--twothirds item--grow" id="cartshark-dashboard">

                <h3>Account-Wide Stats</h3>            

                <div class="gd gd--column gd--gap-30">

                    <div id="cartshark-loading-stats" class="loading-wrap">
                        <span class="loading-img is-active" id="loading-spinner">
                            <svg width="36" height="36" fill="#fff" view-box="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <circle class="spinner_nOfF" cx="4" cy="12" r="3"/>
                                <circle class="spinner_nOfF spinner_fVhf" cx="4" cy="12" r="3"/>
                                <circle class="spinner_nOfF spinner_piVe" cx="4" cy="12" r="3"/>
                                <circle class="spinner_nOfF spinner_MSNs" cx="4" cy="12" r="3"/>
                            </svg>
                        </span>
                        Loading stats...
                    </div>                      

                    <div id="cartshark-message-ajax-stats" style="display:none;">
                        <div class="cartshark-message cartshark-error">
                            <svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="M16 2.667C8.648 2.667 2.667 8.648 2.667 16S8.648 29.333 16 29.333 29.333 23.352 29.333 16 23.352 2.667 16 2.667zm4.943 16.39A1.332 1.332 0 0 1 20 21.333a1.33 1.33 0 0 1-.943-.39L16 17.885l-3.057 3.058a1.33 1.33 0 0 1-1.886 0 1.332 1.332 0 0 1 0-1.886L14.115 16l-3.058-3.057a1.332 1.332 0 0 1 0-1.886 1.332 1.332 0 0 1 1.886 0L16 14.115l3.057-3.058a1.332 1.332 0 0 1 1.886 0 1.332 1.332 0 0 1 0 1.886L17.885 16l3.058 3.057z"/></svg>
                            <p>&nbsp;</p>
                        </div>
                    </div>

                    <div id="cartshark-stats" style="display:none;">

                        <div class="stats-wrap">
                            
                            <div class="stats-box">
                                <h2 id="stat-untrusted">-</h2>
                                <p><strong>New Endpoints</strong></p>
                            </div>

                            <div class="stats-box">
                                <h2 id="stat-trusted">-</h2>
                                <p><strong>Trusted Endpoints</strong></p>
                            </div>

                            <div class="stats-box">
                                <h2 id="stat-pages">-</h2>
                                <p><strong>Scanned (30 days)</strong></p>
                            </div>

                        </div>

                    </div>

                    <div>

                        <h4>Pageviews For This Website</h4>

                        <div id="cartshark-loading-pageviews" class="loading-wrap">
                            <span class="loading-img is-active" id="loading-spinner">
                                <svg width="36" height="36" fill="#fff" view-box="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <circle class="spinner_nOfF" cx="4" cy="12" r="3"/>
                                    <circle class="spinner_nOfF spinner_fVhf" cx="4" cy="12" r="3"/>
                                    <circle class="spinner_nOfF spinner_piVe" cx="4" cy="12" r="3"/>
                                    <circle class="spinner_nOfF spinner_MSNs" cx="4" cy="12" r="3"/>
                                </svg>
                            </span>
                            Loading pageviews...
                        </div>      

                        <div id="cartshark-message-ajax-pageviews" style="display:none;">
                            <div class="cartshark-message cartshark-error">
                                <svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="M16 2.667C8.648 2.667 2.667 8.648 2.667 16S8.648 29.333 16 29.333 29.333 23.352 29.333 16 23.352 2.667 16 2.667zm4.943 16.39A1.332 1.332 0 0 1 20 21.333a1.33 1.33 0 0 1-.943-.39L16 17.885l-3.057 3.058a1.33 1.33 0 0 1-1.886 0 1.332 1.332 0 0 1 0-1.886L14.115 16l-3.058-3.057a1.332 1.332 0 0 1 0-1.886 1.332 1.332 0 0 1 1.886 0L16 14.115l3.057-3.058a1.332 1.332 0 0 1 1.886 0 1.332 1.332 0 0 1 0 1.886L17.885 16l3.058 3.057z"/></svg>
                                <p>&nbsp;</p>
                            </div>
                        </div>

                        <div id="cartshark-pageviews" style="display:none;">

                            <canvas id="pageviewsChart" width="100%" height="200"></canvas>

                        </div>

                    </div> 

                    <div>

                        <h4>Endpoints Found On This Website</h4>
                          
                        <div id="cartshark-loading-endpoints" class="loading-wrap">
                            <span class="loading-img is-active" id="loading-spinner">
                                <svg width="36" height="36" fill="#fff" view-box="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <circle class="spinner_nOfF" cx="4" cy="12" r="3"/>
                                    <circle class="spinner_nOfF spinner_fVhf" cx="4" cy="12" r="3"/>
                                    <circle class="spinner_nOfF spinner_piVe" cx="4" cy="12" r="3"/>
                                    <circle class="spinner_nOfF spinner_MSNs" cx="4" cy="12" r="3"/>
                                </svg>
                            </span>
                            Loading endpoints...
                        </div> 

                        <div id="cartshark-message-ajax-endpoints" style="display:none;">
                            <div class="cartshark-message cartshark-error">
                                <svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="M16 2.667C8.648 2.667 2.667 8.648 2.667 16S8.648 29.333 16 29.333 29.333 23.352 29.333 16 23.352 2.667 16 2.667zm4.943 16.39A1.332 1.332 0 0 1 20 21.333a1.33 1.33 0 0 1-.943-.39L16 17.885l-3.057 3.058a1.33 1.33 0 0 1-1.886 0 1.332 1.332 0 0 1 0-1.886L14.115 16l-3.058-3.057a1.332 1.332 0 0 1 0-1.886 1.332 1.332 0 0 1 1.886 0L16 14.115l3.057-3.058a1.332 1.332 0 0 1 1.886 0 1.332 1.332 0 0 1 0 1.886L17.885 16l3.058 3.057z"/></svg>
                                <p>&nbsp;</p>
                            </div>
                        </div>

                        <div id="cartshark-endpoints" style="display:none;">

                            <table class="form-table full-width">
                                <thead>
                                    <th style="width:170px;">Threat Level</th>
                                    <th>Hostname</th>
                                    <th>Service</th>
                                    <th>&nbsp;</th>
                                </thead>
                                <tbody id="endpoint-list"></tbody>
                            </table>

                        </div>
                    
                    </div>

                </div>

            </section>

            <div class="item--onethird item--max-w-300 gd gd--column gd--gap-20">

                <section class="cartshark-status">
                    
                    <h4>Account Status</h4>

                    <ul class="list--status">
                        <li class="item--tick">Account authenticated</li>
                        <li class="item--tick">Website registered</li>
                        <li class="item--tick">Subscription active</li>
                        <?php if (!$tracker_enabled): ?>
                            <li class="item--cross">Tracker not enabled</li>
                        <?php else: ?>
                            <li class="item--tick">Tracker enabled</li>
                        <?php endif; ?>
                    </ul>

                </section>

                <section class="cartshark-summary">
                    
                    <h4>How Does CartShark Work?</h4>

                    <p>CartShark monitors your live traffic in real-time. We detect when data is sent to a new location, which we call an <strong class="tc--white">Endpoint</strong>.</p>
                    
                    <p>Any Endpoint we detect might be a source of data exfiltration. We provide a threat assessment to help you determine if it's safe and can be trusted.</p>
                    
                    <p>Visit the CartShark app to:</p>

                    <ul class="list--ticks tc--neutral-40">
                        <li>Review your full results</li>
                        <li>Trust known safe endpoints</li>
                        <li>Manage your account and settings</li>
                        <li>Access related security tools, like PCI and GDPR reports</li>
                    </ul>

                </section>

            </div>

        </div>

    </div>

</div>