<?php
/**
 * Template for the authentication page (login/register)
 *
 * Available variables:
 * $cartshark_url - The CartShark app URL
 * $site_domain - Current site domain
 * $return_url - URL to return to after registration
 *
 * @since      1.0.0
 * @package CartShark
 * @subpackage CartShark/admin/partials
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="cartshark-admin-wrap">

    <div class="cartshark-header">

        <header>
            <?php $this->load_template('cartshark-logo.php'); ?>
        </header>
        
        <h1>Let's Get Started</h1>
        <p>Login or create your CartShark account below, and we'll begin monitoring your site traffic.</p>

    </div>
    
    <div id="cartshark-auth-container">

        <div class="cartshark-auth-tabs">
            <button id="login-tab" class="cartshark-tab-button active" data-tab="login">Login</button>
            <button id="register-tab" class="cartshark-tab-button" data-tab="register">Create Account</button>
        </div>

        <!-- Login Form -->
        <section id="login-form" class="cartshark-tab-content active">

            <form id="cartshark-login-form">

                <table class="form-table">
                    <tr>
                        <th scope="row">Email</th>
                        <td>
                            <input type="email" name="email" id="login-email" class="regular-text" placeholder="Your email address" required />
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Password</th>
                        <td>
                            <input type="password" name="password" id="login-password" class="regular-text" placeholder="Enter your password" required />
                        </td>
                    </tr>
                </table>
                
                <div id="login-messages"></div>
                
                <p class="submit">
                    <input type="submit" name="submit" id="login-submit" class="button button-primary" value="Login" />
                    <span class="loading-img" id="login-spinner">
                        <svg width="36" height="36" fill="#fff" view-box="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <circle class="spinner_nOfF" cx="4" cy="12" r="3"/>
                            <circle class="spinner_nOfF spinner_fVhf" cx="4" cy="12" r="3"/>
                            <circle class="spinner_nOfF spinner_piVe" cx="4" cy="12" r="3"/>
                            <circle class="spinner_nOfF spinner_MSNs" cx="4" cy="12" r="3"/>
                        </svg>
                    </span>
                </p>

            </form>

        </section>

        <!-- Register Redirect Info -->
        <section id="register-form" class="cartshark-tab-content">

            <div class="cartshark-register-info">

                <h3>Create Your Account on the CartShark Platform</h3>
                
                <p>Click the button below to create your CartShark account. You'll be taken to our secure registration platform where you can:</p>

                <ul class="list--ticks">
                    <li>Set up your account details</li>
                    <li>Configure your plan</li>
                    <li>Complete the onboarding process</li>
                </ul>

                <p>Once complete, you'll be automatically returned to your WordPress admin.</p>
                
                <p class="submit">
                    <button id="create-account-btn" class="button button-primary" 
                            data-register-url="<?php echo esc_url($cartshark_url); ?>/register"
                            data-return-url="<?php echo esc_url($return_url); ?>"
                            data-site-domain="<?php echo esc_attr($site_domain); ?>"
                            data-site-label="<?php echo esc_attr($site_label); ?>">
                        Create Account
                    </button>
                </p>

            </div>

        </section>

    </div>
</div>