<?php
/**
 * Template for the header actions
 *
 * Available variables:
 * $redirect_url - return URL forthe app
 *
 * @since      1.0.0
 * @package CartShark
 * @subpackage CartShark/admin/partials
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

$redirect_url = admin_url('admin-post.php?action=cartshark_generate_sso_token');
$redirect_url = wp_nonce_url($redirect_url, 'cartshark_onboarding');

?>

<div class="cartshark-actions">

   <span>

      <a href="<?php echo esc_url($redirect_url); ?>" 
         class="button button-primary button-medium" target="_blank">
         Visit the App
         <svg enable-background="new 0 0 32 32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="m29 1h-8c-1.191 0-2 .979-2 2 0 .452.144.952.582 1.415l2.588 2.588-5.584 5.584c-.417.416-.586.934-.586 1.413 0 1.125.875 2 2 2 .521 0 1.024-.195 1.414-.586l5.584-5.584 2.588 2.588c.462.438.962.582 1.414.582 1.021 0 2-.809 2-2v-8c0-1.024-.812-2-2-2zm-4.002 11.659-4.17 4.169c-.754.755-1.759 1.172-2.828 1.172-2.243 0-4-1.757-4-4 0-1.068.416-2.073 1.172-2.828l4.169-4.169-1.174-1.174c-.247-.261-.44-.541-.609-.829h-14.558c-1.105 0-2 .895-2 2v22c0 1.105.895 2 2 2h22c1.105 0 2-.895 2-2v-14.552c-.278-.162-.545-.346-.79-.578z"/></svg>
      </a>

   </span>
   
   <span>

      <button id="logout-btn" class="button button-danger-inverted button-medium">Logout</button>
      
   </span>

</div>