<?php
/**
 * Plugin deactivation handler.
 *
 * @package Carticy\CheckoutShield\Core
 */

declare(strict_types=1);

namespace Carticy\CheckoutShield\Core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Handles plugin deactivation tasks.
 */
final class Deactivator {

	/**
	 * Run deactivation tasks.
	 */
	public static function deactivate(): void {
		// Flush rewrite rules.
		flush_rewrite_rules();

		// Log deactivation.
		if ( function_exists( 'wc_get_logger' ) ) {
			wc_get_logger()->info(
				'Carticy Checkout Shield deactivated',
				array( 'source' => 'carticy-checkout-shield' )
			);
		}

		// Note: We don't delete options on deactivation to preserve settings.
		// Options should only be cleaned up on uninstall.
	}
}
