<?php
/**
 * Plugin Name: Cart to Chat – Send Cart via Messaging
 * Plugin URI: https://dijitalpazarla.com/cart-to-chat
 * Description: Cart page button to send the current WooCommerce cart as a plain-text, line-by-line summary to a configured messaging number (e.g., WhatsApp®). Clean text, no HTML. Helps hesitant buyers complete orders via chat.
 * Version: 1.3.2
 * Author: DijitalPazarla
 * Author URI: https://dijitalpazarla.com/
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: cart-to-chat-send-cart-via-messaging
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

final class CartToChat_Order_Button {
    public function __construct() {
        add_action( 'woocommerce_proceed_to_checkout', [ $this, 'render_button' ], 20 );
        add_action( 'admin_menu', [ $this, 'register_settings_page' ] );
        add_action( 'admin_init', [ $this, 'register_settings' ] );
    }
    public function render_button() {
        if ( ! function_exists( 'WC' ) || ! WC()->cart ) return;
        $phone = trim( get_option( 'carttochat_phone', '' ) );
        if ( empty( $phone ) ) return;
        $message = $this->build_message();
        $wa_link = 'https://wa.me/' . rawurlencode( $phone ) . '?text=' . rawurlencode( $message );
        echo '<a href="' . esc_url( $wa_link ) . '" target="_blank" rel="noopener" class="button alt carttochat-chat-btn">📲 ' . esc_html__( 'Mesajla Sipariş Ver', 'cart-to-chat-send-cart-via-messaging' ) . '</a>';
    }
    private function build_message() {
        $lines   = [];
        $lines[] = "🛒 Yeni Sipariş (Sohbet)";
        $lines[] = "";

        $currency = html_entity_decode( get_woocommerce_currency_symbol(), ENT_QUOTES, 'UTF-8' );
        $decimals = wc_get_price_decimals();

        foreach ( WC()->cart->get_cart() as $item ) {
            if ( empty( $item['data'] ) ) continue;
            $p   = $item['data'];
            $name= $p->get_name();
            $qty = (int) $item['quantity'];
            $price_n = (float) wc_get_price_to_display( $p );
            $price_t = wc_format_decimal( $price_n, $decimals ) . ' ' . $currency;
            $lines[] = "• Ürün: " . $name;
            $lines[] = "Adet: " . $qty;
            $lines[] = "Fiyat: " . $price_t;
            $lines[] = "";
        }

        $totals   = WC()->cart->get_totals();
        $total_n  = isset( $totals['total'] ) ? (float) $totals['total'] : (float) WC()->cart->total;
        $lines[]  = "Toplam: " . wc_format_decimal( $total_n, $decimals ) . ' ' . $currency;

        $lines    = apply_filters( 'carttochat_message_lines', $lines );
        return implode("\n", $lines);
    }
    public function register_settings_page(){ add_options_page('Cart to Chat','Cart to Chat','manage_options','cart-to-chat-send-cart-via-messaging',[ $this,'settings_page_html' ]); }
    public function register_settings(){ register_setting('carttochat_settings','carttochat_phone',[ 'type'=>'string','sanitize_callback'=>[ $this,'sanitize_phone' ],'default'=>'' ]); }
    public function sanitize_phone($v){ return preg_replace('/[^0-9]/','',$v); }
    public function settings_page_html(){ if(!current_user_can('manage_options'))return; ?>
        <div class="wrap"><h1>Cart to Chat Ayarları</h1>
        <form method="post" action="options.php"><?php settings_fields('carttochat_settings');?>
            <table class="form-table"><tr><th scope="row">Mesajlaşma Numarası</th>
            <td><input type="text" name="carttochat_phone" value="<?php echo esc_attr(get_option('carttochat_phone'));?>" placeholder="905xxxxxxxxx" class="regular-text" />
            <p class="description">Uluslararası format (+ olmadan). Örn: 905xxxxxxxxx</p></td></tr></table>
            <?php submit_button(); ?>
            <p class="description">Ticari Marka Uyarısı: WhatsApp® ve WooCommerce kendi sahiplerinin ticari markalarıdır. Bu eklenti onlarla ilişkili değildir.</p>
        </form></div><?php }
}
new CartToChat_Order_Button();
