<?php
/**
 * Plugin Name: Cart reset
 * Plugin URI: http://ouzay.com/cart-reset
 * Description: A plugin demonstrating how to reset a cart of WooCommerce.
 * Author:  YASIN OUZAY.
 * Author URI: http://ouzay.com
 * Version: 1.0
 */

if ( ! class_exists( 'WC_cart_reset_plugin' ) ) :

class WC_cart_reset_plugin {
  /**
  * Construct the plugin.
  */
  public $value;
  
  public function __construct() {
    add_action( 'plugins_loaded', array( $this, 'init' ) );
	
  }
  /**
  * Initialize the plugin.
  */
  public function init() {
    // Checks if WooCommerce is installed.
    if ( class_exists( 'WC_Integration' ) ) {
		// Include our integration class.
		include_once 'inc/class-wc-cart-reset-integration.php';
		
		$WC_cart_reset_Integration = new WC_cart_reset_Integration( __FILE__ );
		$custom_name = $WC_cart_reset_Integration->custom_name;
		$this->value = $custom_name;
		
		// Register the integration.
		add_filter( 'woocommerce_integrations', array( $this, 'add_integration' ) );
		add_action( 'woocommerce_proceed_to_checkout', array($this,'woocommerce_clear_cart_url'));

    }
  }
  /**
   * Add a new integration to WooCommerce.
   */
	public function add_integration( $integrations ) {

		$integrations[] = 'WC_cart_reset_Integration';

		return $integrations;
	
	}
	public function woocommerce_clear_cart_url() {

		if (isset($_GET['type']) && $_GET['type'] == $this->value ) {
			
			WC()->session->set('cart', array()); 
			
		}
	}
}

$WC_cart_reset_plugin = new WC_cart_reset_plugin( __FILE__ );

endif;
