<?php
/**
 * Integration Woocommerce cart reset.
 *
 * @package   Woocommerce cart reset Integration
 * @category Woocommerce cart
 * @author   YASIN OUZAY.
 */
if ( ! class_exists( 'WC_cart_reset_Integration' ) ) :

class WC_cart_reset_Integration extends WC_Integration {
  /**
   * Init and hook in the integration.
   */
  public function __construct() {
    global $woocommerce;
    $this->id                 = 'cart-reset';
    $this->method_title       = __( 'Woocommerce cart reset');
    $this->method_description = __( 'Woocommerce cart reset show you how easy it is to extend WooCommerce by reset cart.');
    // Load the settings.
    $this->init_form_fields();
    $this->init_settings();
    // Define user set variables.
    $this->custom_name          = $this->get_option( 'custom_name' );
    // Actions.
    add_action( 'woocommerce_update_options_integration_' .  $this->id, array( $this, 'process_admin_options' ) );

  }
  /**
   * Initialize integration settings form fields.
   */
  public function init_form_fields() {
    $this->form_fields = array(
      'custom_name' => array(
        'title'             => __( 'Chose your own variable'),
        'type'              => 'text',
        'description'       => __( 'Enter variable after ?add-to-cart&xxxxxxx'),
        'desc_tip'          => true,
        'default'           => '',
        'css'      => 'width:200px;',
      ),
    );
  } 
}

endif; 