// Frontend JavaScript for Card to Card Gateway
(function ($) {
    'use strict';

    // Copy to clipboard functionality
    window.copyToClipboard = function (text) {
        if (navigator.clipboard && window.isSecureContext) {
            // Use modern clipboard API
            navigator.clipboard.writeText(text).then(function () {
                // Optional: Show success message
                console.log('Card number copied to clipboard');
            }).catch(function (err) {
                console.error('Failed to copy: ', err);
            });
        } else {
            // Fallback for older browsers
            var textArea = document.createElement('textarea');
            textArea.value = text;
            textArea.style.position = 'fixed';
            textArea.style.left = '-999999px';
            textArea.style.top = '-999999px';
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();

            try {
                document.execCommand('copy');
                console.log('Card number copied to clipboard');
            } catch (err) {
                console.error('Failed to copy: ', err);
            }

            document.body.removeChild(textArea);
        }
    };

})(jQuery);