(function ($) {
    'use strict';

    function toggleTelegramFields() {
        // Try multiple possible checkbox selectors for EDD
        var checkbox = $(
            '#edd_settings_gateways_mmz_ctc_telegram_enable, ' +
            '#edd_settings\\[mmz_ctc_telegram_enable\\], ' +
            'input[name="edd_settings[mmz_ctc_telegram_enable]"]'
        );
        var enabled = checkbox.is(':checked');

        // Target the specific Telegram fields by their IDs
        var tokenField = $(
            '#edd_settings_gateways_mmz_ctc_telegram_bot_token, ' +
            '#edd_settings\\[mmz_ctc_telegram_bot_token\\], ' +
            'input[name="edd_settings[mmz_ctc_telegram_bot_token]"]'
        );
        var chatIdField = $(
            '#edd_settings_gateways_mmz_ctc_telegram_chat_id, ' +
            '#edd_settings\\[mmz_ctc_telegram_chat_id\\], ' +
            'input[name="edd_settings[mmz_ctc_telegram_chat_id]"]'
        );

        // Toggle the parent table rows
        if (enabled) {
            tokenField.closest('tr').show();
            chatIdField.closest('tr').show();
        } else {
            tokenField.closest('tr').hide();
            chatIdField.closest('tr').hide();
        }
    }

    function toggleCustomBankIcon() {
        var selectField = $(
            '#edd_settings_gateways_mmz_ctc_bank_icon, ' +
            '#edd_settings\\[mmz_ctc_bank_icon\\], ' +
            'select[name="edd_settings[mmz_ctc_bank_icon]"]'
        );
        var selectedBank = selectField.val();

        var customField = $(
            '#edd_settings_gateways_mmz_ctc_custom_bank_icon, ' +
            '#edd_settings\\[mmz_ctc_custom_bank_icon\\], ' +
            'input[name="edd_settings[mmz_ctc_custom_bank_icon]"]'
        );
        var customRow = customField.closest('tr');

        if (selectedBank === 'custom') {
            customRow.show();
        } else {
            customRow.hide();
        }
    }

    $(document).ready(function () {
        // Initial toggle for Telegram fields
        toggleTelegramFields();

        // Bind to checkbox change
        $(document).on('change',
            '#edd_settings_gateways_mmz_ctc_telegram_enable, ' +
            '#edd_settings\\[mmz_ctc_telegram_enable\\], ' +
            'input[name="edd_settings[mmz_ctc_telegram_enable]"]',
            toggleTelegramFields
        );

        // Initial toggle for custom bank icon
        toggleCustomBankIcon();

        // Bind to select change
        $(document).on('change',
            '#edd_settings_gateways_mmz_ctc_bank_icon, ' +
            '#edd_settings\\[mmz_ctc_bank_icon\\], ' +
            'select[name="edd_settings[mmz_ctc_bank_icon]"]',
            toggleCustomBankIcon
        );
    });
})(jQuery);