<?php
/**
 * SettingsOptions
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CallNowButton API
 *
 * API for CallNowButton. Includes auth, domains, buttons/actions/conditions, but also chat and admin features.
 *
 * The version of the OpenAPI document: 0.0.219-local
 * Contact: support@nowbuttons.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace cnb\api\Model;

use \ArrayAccess;
use \cnb\api\ObjectSerializer;

/**
 * SettingsOptions Class Doc Comment
 *
 * @category Class
 * @description Settings options for the user.
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SettingsOptions implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SettingsOptions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'css_location' => 'string',
        'js_location' => 'string',
        'static_root' => 'string',
        'user_root' => 'string',
        'api_root' => 'string',
        'chat_root' => 'string',
        'storage_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'css_location' => null,
        'js_location' => null,
        'static_root' => null,
        'user_root' => null,
        'api_root' => null,
        'chat_root' => null,
        'storage_type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'css_location' => false,
        'js_location' => false,
        'static_root' => false,
        'user_root' => false,
        'api_root' => false,
        'chat_root' => false,
        'storage_type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'css_location' => 'cssLocation',
        'js_location' => 'jsLocation',
        'static_root' => 'staticRoot',
        'user_root' => 'userRoot',
        'api_root' => 'apiRoot',
        'chat_root' => 'chatRoot',
        'storage_type' => 'storageType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'css_location' => 'setCssLocation',
        'js_location' => 'setJsLocation',
        'static_root' => 'setStaticRoot',
        'user_root' => 'setUserRoot',
        'api_root' => 'setApiRoot',
        'chat_root' => 'setChatRoot',
        'storage_type' => 'setStorageType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'css_location' => 'getCssLocation',
        'js_location' => 'getJsLocation',
        'static_root' => 'getStaticRoot',
        'user_root' => 'getUserRoot',
        'api_root' => 'getApiRoot',
        'chat_root' => 'getChatRoot',
        'storage_type' => 'getStorageType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const STORAGE_TYPE_GCS = 'GCS';
    public const STORAGE_TYPE_R2 = 'R2';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStorageTypeAllowableValues()
    {
        return [
            self::STORAGE_TYPE_GCS,
            self::STORAGE_TYPE_R2,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('css_location', $data ?? [], null);
        $this->setIfExists('js_location', $data ?? [], null);
        $this->setIfExists('static_root', $data ?? [], null);
        $this->setIfExists('user_root', $data ?? [], null);
        $this->setIfExists('api_root', $data ?? [], null);
        $this->setIfExists('chat_root', $data ?? [], null);
        $this->setIfExists('storage_type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['css_location'] === null) {
            $invalidProperties[] = "'css_location' can't be null";
        }
        if ($this->container['js_location'] === null) {
            $invalidProperties[] = "'js_location' can't be null";
        }
        if ($this->container['static_root'] === null) {
            $invalidProperties[] = "'static_root' can't be null";
        }
        if ($this->container['user_root'] === null) {
            $invalidProperties[] = "'user_root' can't be null";
        }
        if ($this->container['api_root'] === null) {
            $invalidProperties[] = "'api_root' can't be null";
        }
        if ($this->container['chat_root'] === null) {
            $invalidProperties[] = "'chat_root' can't be null";
        }
        if ($this->container['storage_type'] === null) {
            $invalidProperties[] = "'storage_type' can't be null";
        }
        $allowedValues = $this->getStorageTypeAllowableValues();
        if (!is_null($this->container['storage_type']) && !in_array($this->container['storage_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'storage_type', must be one of '%s'",
                $this->container['storage_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets css_location
     *
     * @return string
     */
    public function getCssLocation()
    {
        return $this->container['css_location'];
    }

    /**
     * Sets css_location
     *
     * @param string $css_location css_location
     *
     * @return self
     */
    public function setCssLocation($css_location)
    {
        if (is_null($css_location)) {
            throw new \InvalidArgumentException('non-nullable css_location cannot be null');
        }
        $this->container['css_location'] = $css_location;

        return $this;
    }

    /**
     * Gets js_location
     *
     * @return string
     */
    public function getJsLocation()
    {
        return $this->container['js_location'];
    }

    /**
     * Sets js_location
     *
     * @param string $js_location js_location
     *
     * @return self
     */
    public function setJsLocation($js_location)
    {
        if (is_null($js_location)) {
            throw new \InvalidArgumentException('non-nullable js_location cannot be null');
        }
        $this->container['js_location'] = $js_location;

        return $this;
    }

    /**
     * Gets static_root
     *
     * @return string
     */
    public function getStaticRoot()
    {
        return $this->container['static_root'];
    }

    /**
     * Sets static_root
     *
     * @param string $static_root static_root
     *
     * @return self
     */
    public function setStaticRoot($static_root)
    {
        if (is_null($static_root)) {
            throw new \InvalidArgumentException('non-nullable static_root cannot be null');
        }
        $this->container['static_root'] = $static_root;

        return $this;
    }

    /**
     * Gets user_root
     *
     * @return string
     */
    public function getUserRoot()
    {
        return $this->container['user_root'];
    }

    /**
     * Sets user_root
     *
     * @param string $user_root user_root
     *
     * @return self
     */
    public function setUserRoot($user_root)
    {
        if (is_null($user_root)) {
            throw new \InvalidArgumentException('non-nullable user_root cannot be null');
        }
        $this->container['user_root'] = $user_root;

        return $this;
    }

    /**
     * Gets api_root
     *
     * @return string
     */
    public function getApiRoot()
    {
        return $this->container['api_root'];
    }

    /**
     * Sets api_root
     *
     * @param string $api_root api_root
     *
     * @return self
     */
    public function setApiRoot($api_root)
    {
        if (is_null($api_root)) {
            throw new \InvalidArgumentException('non-nullable api_root cannot be null');
        }
        $this->container['api_root'] = $api_root;

        return $this;
    }

    /**
     * Gets chat_root
     *
     * @return string
     */
    public function getChatRoot()
    {
        return $this->container['chat_root'];
    }

    /**
     * Sets chat_root
     *
     * @param string $chat_root chat_root
     *
     * @return self
     */
    public function setChatRoot($chat_root)
    {
        if (is_null($chat_root)) {
            throw new \InvalidArgumentException('non-nullable chat_root cannot be null');
        }
        $this->container['chat_root'] = $chat_root;

        return $this;
    }

    /**
     * Gets storage_type
     *
     * @return string
     */
    public function getStorageType()
    {
        return $this->container['storage_type'];
    }

    /**
     * Sets storage_type
     *
     * @param string $storage_type storage_type
     *
     * @return self
     */
    public function setStorageType($storage_type)
    {
        if (is_null($storage_type)) {
            throw new \InvalidArgumentException('non-nullable storage_type cannot be null');
        }
        $allowedValues = $this->getStorageTypeAllowableValues();
        if (!in_array($storage_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'storage_type', must be one of '%s'",
                    $storage_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['storage_type'] = $storage_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


